<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\User;
use Carbon\Carbon;

class HomeController extends Controller
{
    public function index(){
        $title = 'الرئيسية';
        $users_chart = User::whereDate('created_at', '>=', Carbon::now()->subMonths(6) )
                            ->whereDate('created_at', '<=', Carbon::now())
                            ->select( \DB::raw('COUNT(*) as a, DATE_FORMAT(created_at, "%Y-%m") as y'))
                            // ->groupBy('user_id')
                            ->groupBy('y')
                            ->get();
        $orders_chart = Order::whereDate('created_at', '>=', Carbon::now()->subMonths(6) )
                            ->whereDate('created_at', '<=', Carbon::now())
                            ->select( \DB::raw('COUNT(*) as a, DATE_FORMAT(created_at, "%Y-%m") as y'))
                            // ->groupBy('user_id')
                            ->groupBy('y')
                            ->get();
        $order_statuses_chart = [];
        $order_statuses_colors = [];
        foreach (OrderStatus() as $key =>$value)
        {
            $i = new \stdClass;
            $i->label = $value;
            $i->value = Order::where('status','=',$key)->count();
            $order_statuses_chart[] = $i;
            $order_statuses_colors[] = scolors($key);
        }
        $order_statuses_chart = json_encode($order_statuses_chart);
        $order_statuses_colors = json_encode($order_statuses_colors);
    	$now = Carbon::now();
        $orders = Order::whereDate('day_date', Carbon::today())->latest();
    	$search = array();
    	
        $orders = $orders->paginate(20);
    	return view('admin.main', compact('search', 'users_chart', 'orders_chart', 'orders', 'order_statuses_chart', 'order_statuses_colors', 'title'));
    
    }
}
