<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Driver;
use App\Models\Order;
use App\Models\OrderFinance;
use App\Models\Status;
use Carbon\Carbon;
use App\Models\Admin;
use App\Notifications\AdminNotification;
use App\Notifications\GeneralNotification;
use App\Http\Resources\Api\SingleOrderResource;
use App\Http\Resources\Api\OrderResource;

class DriverOrderController extends Controller
{
   
   
    public function index(Request $request)
    {
        $driver = auth('api-driver')->user();
        $ordersd = $driver->Order();
        if ($request->has('day_date')) {
            $ordersd = $ordersd->whereDate('day_date', $request->get('day_date') );
        }
        
        $orders = $driver->Order();
        if ($request->has('day_date')) {
            $orders = $orders->whereDate('day_date', $request->get('day_date') );
        }
        $orders = $orders->where('status', 'completed')->get();
        
        $ids = $orders->pluck('id')->toArray();
        $finance = OrderFinance::whereIn('order_id', $ids)->get();
        $invoices_total = $finance->sum('total_amount');
        $services_total = $finance->sum('services_amount');
        $driver_total = $finance->sum('driver_amount');
        $target_total = $finance->sum('target_amount');
        $pure_total = $finance->sum('pure_amount');
        $orders = OrderResource::collection($orders);
        $ordersC = $driver->Order();
        if ($request->has('day_date')) {
            $ordersC = $ordersC->whereDate('day_date', $request->get('day_date') );
            
        }
        $ordersC = $ordersC->where('status','<>', 'completed')->get();
        $ordersC = OrderResource::collection($ordersC);
        return Response()->json([
            'data'          => [
                'current_orders'  => $ordersC,
                'previous_orders'  => $orders,
                'orders_count'  => $ordersd->count(),
                'current_orders_count'  => $ordersC->count(),
                'pre_orders_count'  => $orders->count(),
                'orders_cost'  => $ordersd->where('payment_type', 'cash')->sum('total'),
                'invoices_total'  => $invoices_total,
                'driver_total'  => $services_total - $driver->target,
                'company_owed_total'  => $invoices_total - ($services_total - $driver->target),
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
   
    public function CompleteOrderCount()
    {
        $driver = auth('api-driver')->user();
        $count = $driver->Order()
                        ->whereHas('Status', function($q){
                            $q->where('key', 'completed');
                        })
                        ->whereDate('updated_at', Carbon::now())
                        ->count();
        $total = $driver->Order()
                        ->whereHas('Status', function($q){
                            $q->where('key', 'completed');
                        })
                        ->whereDate('updated_at', Carbon::now())
                        ->sum('price');
        return Response()->json([
            'data'          => [
                'count'  => $count,
                'total'  => $total,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function changestatus(Request $request)
    {
        $driver = auth('api-driver')->user();
        $data = [];
        $order = $driver->Order()->find($request->order_id);
        $user = $order->User()->first();
        $status = $request->get('status');
        // $data['price'] = ;
        // $data['commission'] = ;
        $data['status'] = $status;
        if (!in_array($status, ['washing_car', 'completed', 'driver_on_the_way'])) {
            return Response()->json([
                'data'          => [
                ],
                'message'       => 'status not allowed',
                'code'          => 500,
            ]);
        }
        $order->update($data);

        // send notification to driver
        if( $user->lang == 'ar')
        {
            $title = "spray" ;
            $content = "تم تغيير حالة الحجز  #". $order->id . " الي " . getStatus($status, 'ar') ;

        }else{
            $title = "spray";
            $content = "Order  #".$order->id  . " status changed  to " . getStatus($status, 'en') ;
        }
        $type = $status;
        
        $title_ar = "spray" ;
        $title_en = "spray "  ;
        $content_ar = "تم تغيير حالة الحجز  #".$order->id  . " الي " . getStatus($status, 'ar');
        $content_en = "Order  #".$order->id  . " status changed  to " . getStatus($status, 'en') ;
        $activity = "order_status_changed_by_driver";
        $order = Order::where('id', $order->id)->first();
        if ($status == 'completed') {
            $target = $order->Driver->target;
            $price = $order->Service()->first()->PriceList()->where('size', $order->Car->size)->first()->price;
            if ($order->OrderFinance()->count() == 0) {
                
                $order->OrderFinance()->create([
                    'total_amount' => $order->total,
                    'services_amount' => $price,
                    'target_amount' => $target,
                    'driver_amount' => 0,
                    'pure_amount' => 0,
                ]);
            }
        }
        $order = new SingleOrderResource($order);
        if ($type == 'completed') {
            
            $data2 = [
                'order' => $order,
                'title_ar' => $title_ar,
                'title_en' => $title_en,
                'content_ar' => $content_ar,
                'content_en' => $content_en,
                'type' => $type,
            ];
            $token = $user->PlayerId()->pluck('player_id')->toArray();
            $user->notify(new GeneralNotification($title, $content,$type,$data2));
            $admin = Admin::first();
            if ($admin) {
                $admin->notify(new AdminNotification($content_ar, route('orders.show', $order->id)));
            }
            FCMController::Push($title, $content,$token,$data2, $activity);
        }else{

            $data2 = [
                'order' => $order,
                'title_ar' => $title_ar,
                'title_en' => $title_en,
                'content_ar' => $content_ar,
                'content_en' => $content_en,
                'type' => 'status_changed',
            ];
            $token = $user->PlayerId()->pluck('player_id')->toArray();
            $user->notify(new GeneralNotification($title, $content,'status_changed',$data2));
            $admin = Admin::first();
            if ($admin) {
                $admin->notify(new AdminNotification($content_ar, route('orders.show', $order->id)));
            }
            // return dd(FCMController::Push($title, $content,['fF23M-jFQimrX3cn3qUAss:APA91bFUH2Iclq8YqC15ukNGG6AHzYCOq0dYRcCJz45nu3tprfCMtaR9ZDwpVZ78KE6e_Wme87We2uUYEUhbLjmvMkOUb3W-kLqA-jlWMadjbbQmN8h1axkRiQpJNOl8Sl6zHyVmeZ-q'],$data2, $activity));
            FCMController::Push($title, $content,$token,$data2, 'status_changed'); 
        }
        // send notification to driver
        $order_total = $request->items * $driver->price;

        return Response()->json([
            'data'          => [
                'order'  => $order,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $user = auth('api-driver')->user();
        $order = $user->Order()->find($id);
        
        $order = new SingleOrderResource($order);
        return Response()->json([
            'data'          => [
                'order'  => $order,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
