<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $token = '';
        if ($this->token) {
            $token = $this->token;
        }
        return [
            'id'            => $this->id, 
            'name'    => $this->name, 
            // 'last_name'     => $this->last_name, 
            'name'          => $this->name, 
            'email'         => $this->email,  
            'phone'         => $this->phone, 
            // 'phone'         => '0'.$this->phone, 
            'image'         => $this->image, 
            'city_id'       => $this->city_id, 
            'gender'        => $this->gender, 
            'city' => new CityResource($this->City()->first()),
            // 'latitude'      => $this->latitude, 
            // 'longitude'      => $this->longitude, 
            // 'address'       => $this->address,
            'token'         => $token,
            'fcm_tokens'   => $this->PlayerId()->pluck('player_id')->toArray(),
        ];
    }
}
