<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Car extends Model
{
    protected $table='cars';
    protected $fillable = [
        'name' , 'plate_number' , 'plate_number2', 'image', 'brand_id', 'brand_model_id', 'color_id', 'size', 'user_id'
    ];

    
    public function User()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function Color()
    {
        return $this->belongsTo(Color::class, 'color_id');
    }
    public function Order()
    {
        return $this->HasMany(Order::class, 'car_id');
    }
    public function Brand()
    {
        return $this->belongsTo(Brand::class, 'brand_id');
    }
    public function BrandModel()
    {
        return $this->belongsTo(BrandModel::class, 'brand_model_id');
    }
    public function getImageAttribute($img)
    {
        if($img)
        {
            return url('/').'/cdn/'.$img;
        }
        return $img;

    }
}
