<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model
{
    use SoftDeletes;
    protected $table='orders';
    protected $fillable = [
        'user_id' , 'car_id' , 'driver_id' , 'original_total' , 'total' , 'discount' , 'status' , 
        'payment_type' , 'rate', 'start_time', 'end_time', 'day_date', 'service_id', 'latitude', 'longitude', 'address', 'city_id', 'coupon', 
        'tax', 'service_price', 'coupon_amount', 'notes'
    ];
    protected $appends= ['start', 'end', 'car_size', 'updated_at_stamp'];

    public static function statuses($key)
    {
        switch ($key) {
            case 'pending':
                $arr = [
                    'pending' => 'placed on driver',
                    'proccessing' => 'Proccessing',
                    'driver_on_the_way' => 'Driver On The Way',
                    'washing_car' => 'Washing Car',
                    'completed' => 'Request Completed',
                    'canceled' => 'Request Canceled',
                ];
                break;
            case 'proccessing':
                $arr = [
                    // 'pending' => 'placed on driver',
                    'proccessing' => 'Proccessing',
                    'driver_on_the_way' => 'Driver On The Way',
                    'washing_car' => 'Washing Car',
                    'completed' => 'Request Completed',
                    'canceled' => 'Request Canceled',
                ];
                break;
            case 'driver_on_the_way':
                $arr = [
                    // 'pending' => 'placed on driver',
                    // 'proccessing' => 'Proccessing',
                    'driver_on_the_way' => 'Driver On The Way',
                    'washing_car' => 'Washing Car',
                    'completed' => 'Request Completed',
                    // 'canceled' => 'Request Canceled',
                ];
                break;
            case 'washing_car':
                $arr = [
                    // 'pending' => 'placed on driver',
                    // 'proccessing' => 'Proccessing',
                    // 'driver_on_the_way' => 'Driver On The Way',
                    'washing_car' => 'Washing Car',
                    'completed' => 'Request Completed',
                    // 'canceled' => 'Request Canceled',
                ];
                break;
            case 'completed':
                $arr = [
                    // 'pending' => 'placed on driver',
                    // 'proccessing' => 'Proccessing',
                    // 'driver_on_the_way' => 'Driver On The Way',
                    // 'washing_car' => 'Washing Car',
                    'completed' => 'Request Completed',
                    // 'canceled' => 'Request Canceled',
                ];
                break;
            
            default:
            $arr = [
                'pending' => 'placed on driver',
                'proccessing' => 'Proccessing',
                'driver_on_the_way' => 'Driver On The Way',
                'washing_car' => 'Washing Car',
                'completed' => 'Request Completed',
                'canceled' => 'Request Canceled',
            ];
                break;
        }
        return $arr;
    }
    public function User()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function Car()
    {
        return $this->belongsTo(Car::class, 'car_id');
    }

    public function Service()
    {
        return $this->belongsTo(Service::class, 'service_id');
    }

    public function Driver()
    {
        return $this->belongsTo(Driver::class, 'driver_id');
    }

    public function OrderItem()
    {
        return $this->Hasmany(OrderItem::class, 'order_id');
    }

    public function OrderFinance()
    {
        return $this->HasOne(OrderFinance::class, 'order_id');
    }
    public function getStartAttribute()
    {
        $Time= Carbon::parse($this->start_time);
        return $stime = ($Time->hour * 60) + $Time->minute;
    }
    public function getEndAttribute()
    {
        $Time= Carbon::parse($this->end_time);
        return $stime = ($Time->hour * 60) + $Time->minute;
    }
    public function getCarSizeAttribute()
    {
        return $this->Car->size ?? '';
    }
    public function getTotalAttribute($val)
    {
        return round($val,2);
    }
    public function getOriginalTotalAttribute($val)
    {
        return round($val,2);
    }
    public function getDiscountAttribute($val)
    {
        return round($val,2);
    }
    public function getUpdatedAtStampAttribute()
    {
        return $this->updated_at->timestamp;
    }

}
