@extends('admin.layout.app')
@section('style')
<style>
    table {
        border-collapse: collapse;
        border: 1px solid black;
    }


    td,
    th {

        text-align: right;
        padding: 7px;
        border-bottom: 1px solid black;
    }

    .qrcode div {
        margin: auto;
    }

    @media print {
        .xc {
            text-align: left !important;
            border: 1px solid #000 !important;
            background-color: #000 !important;
            color: #fff !important;
            width: 2rem !important;
        }
    }

</style>
@endsection
@section('header')
<li>
</li>
@endsection
@section('content')
<div class="card-box">

    <div class="row">

        <div class="col-md-6">
            <div class="col-md-12 text-center" style="">
                <h3> تفاصيل الحجز </h3>
            </div>
            <table class="table table-striped" style="  border: 1px solid gray;">
                <thead>

                <tbody>
                    <tr>
                        <th scope="row" style="  border: 1px solid gray;  color:#000;"> #</th>
                        <td style="  border: 1px solid gray;">{{$order->id ?? ''}}</td>
                    </tr>
                    <tr>
                        <th scope="row" style="  border: 1px solid gray;  color:#000;">اسم العميل</th>
                        <td style="  border: 1px solid gray;">{{$order->User->name ?? ''}}</td>
                    </tr>
                    <tr>
                        <th scope="row" style="  border: 1px solid gray;  color:#000;"> السعر الكلي </th>
                        <td style="  border: 1px solid gray;">{{$order->total}} ريال</td>

                    </tr>
                    <tr>
                        <th scope="row" style="  border: 1px solid gray;  color:#000;"> الحاله </th>
                        <td style="  border: 1px solid gray;">{{getStatus($order->status, 'ar')}}</td>

                    </tr>
                    @if ($order->original_price)
                        
                    <tr>
                        <th scope="row" style="  border: 1px solid gray;  color:#000;"> السعر قبل الخصم </th>
                        <td style="  border: 1px solid gray;">{{$order->original_price}} ريال</td>

                    </tr>
                    @endif
                    @if ($order->discount)
                        
                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;"> الخصم </th>
                        <td style="  border: 1px solid gray;">{{$order->discount}} ريال</td>

                    </tr>
                    @endif
                    @if ($order->coupon)
                        
                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;"> كوبون  </th>
                        <td style="  border: 1px solid gray;">{{$order->coupon}}</td>

                    </tr>
                        
                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;">  قيمة الكوبون </th>
                        <td style="  border: 1px solid gray;">{{$order->coupon_amount}} ريال</td>

                    </tr>
                    @endif
                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;"> القيمة المضافة</th>
                        <td style="  border: 1px solid gray;">
                            {{$order->tax}}
                            <br>
                            {{number_format($order->total / (100 + (100*$order->tax)) * (100*$order->tax),2)}} ريال
                        </td>

                    </tr>
                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;"> الاجمالي </th>
                        <td style="  border: 1px solid gray;">{{$order->total}} ريال</td>

                    </tr>
                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;"> طريقه الدفع </th>
                        <td style="  border: 1px solid gray;">{{$order->payment_type}}</td>

                    </tr>
                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;"> الخدمة </th>
                        <td style="  border: 1px solid gray;">{{$order->Service->name ?? ''}}</td>

                    </tr>
                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;"> ملحوظات </th>
                        <td style="  border: 1px solid gray;">{{$order->notes}}</td>

                    </tr>
                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;"> التقييم </th>
                        <td style="  border: 1px solid gray;">{{$order->rate}}</td>

                    </tr>
                </tbody>
            </table>
            <div id="map" style="width: 100%; height:250px;"></div>
        </div>



        {{--  'name', 'email', 'password', 'phone' , 'role' , 'image' , 'latitude' , 'longitude' , 'address' , 
        'verified', 'code' , 'social_id', 'social_type', 'branch_id' , 'status'  --}}

        <div class="col-md-6">
            <div class="col-md-12 text-center" style="">
                <h3> تفاصيل العميل </h3>
            </div>
            <table class="table table-striped" style="  border: 1px solid gray;">
                <thead>

                <tbody>
                    <tr style="  border: 1px solid gray;">
                        <th scope="row" style="  border: 1px solid gray; color:#000;">اسم العميل</th>
                        <td style="  border: 1px solid gray;">{{$order->User->name ?? ''}}</td>

                    </tr>

                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;">البريد الالكترونى</th>
                        <td style="  border: 1px solid gray;">{{$order->User->email ?? ''}}</td>

                    </tr>
                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;"> رقم الجوال</th>
                        <td style="  border: 1px solid gray;">{{$order->User->phone?? ''}}</td>

                    </tr>



                </tbody>
            </table>
            <div class="col-md-12 text-center" style="">
                <h3> تفاصيل السيارة </h3>
            </div>
            <table class="table table-striped" style="  border: 1px solid gray;">
                <thead>

                <tbody>
                    <tr style="  border: 1px solid gray;">
                        <th scope="row" style="  border: 1px solid gray; color:#000;">الاسم</th>
                        <td style="  border: 1px solid gray;">{{$order->Car->name ?? ''}}</td>

                    </tr>

                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;">رقم اللوحه </th>
                        <td style="  border: 1px solid gray;">{{$order->Car->plate_number ?? ''}} {{$order->Car->plate_number2 ?? ''}}</td>

                    </tr>
                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;">الماركه</th>
                        <td style="  border: 1px solid gray;">{{$order->Car->BrandModel->name_ar?? ''}}</td>

                    </tr>
                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;">اللون</th>
                        <td style="  border: 1px solid gray;">{{$order->Car->Color->name_ar?? ''}}</td>

                    </tr>
                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;">الحجم</th>
                        <td style="  border: 1px solid gray;">{{$order->Car->size ?? ''}}</td>

                    </tr>



                </tbody>
            </table>
            <div class="col-md-12 text-center" style="">
                <h3> تفاصيل السائق </h3>
            </div>
            <table class="table table-striped" style="  border: 1px solid gray;">
                <thead>

                <tbody>
                    <tr style="  border: 1px solid gray;">
                        <th scope="row" style="  border: 1px solid gray; color:#000;">الاسم </th>
                        <td style="  border: 1px solid gray;">{{$order->Driver->name ?? ''}}</td>

                    </tr>

                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;"> رقم الجوال</th>
                        <td style="  border: 1px solid gray;">{{$order->Driver->phone?? ''}}</td>

                    </tr>



                </tbody>
            </table>
            <table class="table table-bordered" style=" border: 1px solid gray;">
                {{--  <thead>
                    <tr style=" border: 1px solid black;">
                        <th style="text-align:right; border: 1px solid black;" >التاريخ</th>
                        <th style="text-align:right; border: 1px solid black;">الحالة</th>
                    </tr>
                </thead>  --}}
                <tbody>
                    {{--  @foreach ($order->OrderLog()->get() as $item)
                    <tr style=" border: 1px solid black;">
                        <td style=" border: 1px solid black;">{{$item->created_at->toDateString()}}</td>
                    <td style=" border: 1px solid black;">{{$item->details}}</td>
                    </tr>
                    @endforeach --}}

                </tbody>
            </table>
        </div>


    </div>
    {{--  'title_ar', 'title_en', 'description_ar' , 'description_en' , 'price', 'image' , 'active' , 'new_price',
    'category_id', 'sku' , 'status'  --}}
    <div class="row">
        <div class="col-md-12">
            <div class="col-md-12 text-center" style="">
                <h3> المنتجات </h3>
            </div>
            <table class="table table-striped" style="  border: 1px solid gray;">
                <thead>
                    <thead>
                        <tr>
                            <th> الصورة</th>
                            <th>العنوان </th>
                            <th> السعر </th>
                            <th> الكميه </th>
                            <th> الاجمالي </th>

                        </tr>

                    </thead>
                <tbody>
                    @foreach ($order->OrderItem()->get() as $item)

                    <tr>
                        <td style="  border: 1px solid gray; color:#000;">
                            <img style="height: 100px; width: 100px" src="{{$item->Product->image ?? ''}}" />
                        </td>
                        <td style="  border: 1px solid gray; color:#000;">{{$item->Product->name ?? ''}}</td>
                        <td style="  border: 1px solid gray; color:#000;">{{$item->price ?? ''}} ريال</td>
                        <td style="  border: 1px solid gray; color:#000;">{{$item->qty}}</td>
                        <td style="  border: 1px solid gray; color:#000;">{{$item->qty * $item->price}} ريال</td>

                    </tr>
                    @endforeach

                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

@section('script')
<script type="text/javascript"
    src="https://maps.google.com/maps/api/js?sensor=false&libraries=places&key=AIzaSyCob-v1r_8bpOUPIm4TiaxrD3roc_XLFFo&language=ar">
</script>
<script>
    function initMap() {
      const myLatLng = { lat: parseFloat('{{$order->latitude}}'), lng: parseFloat('{{$order->longitude}}') };
      const map = new google.maps.Map(document.getElementById("map"), {
        zoom: 12,
        center: myLatLng,
      });
      new google.maps.Marker({
        position: myLatLng,
        map,
        title: "Hello World!",
      });
    }
    initMap();
  </script>
@endsection