<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateOrderRequest;
use App\Http\Requests\Admin\StoreOrderRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\OrderOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Order;
use Auth;
use Excel;
use App\Exports\GeneralExport;
use App\Http\Controllers\Api\AppInfoController;
use App\Models\Driver;
use App\Models\OrderItem;
use App\Models\PriceList;
use App\Models\Product;
use App\Models\Service;
use App\Models\Shift;
use Carbon\Carbon;
use Carbon\CarbonInterval;

class OrderController extends Controller
{
    use OrderOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        $this->middleware('Permission:orders_show'    , ['only' => 'index', 'show']);
        $this->middleware('Permission:orders_add'     , ['only' => 'create', 'store']);
        $this->middleware('Permission:orders_edit'    , ['only' => 'edit', 'update']);
        $this->middleware('Permission:orders_delete'  , ['only' => 'destroy']);
    }
    public function index(Request $request)
    {
        // $orders = Order::latest();
      //////////////////// branch or admin
      if (in_array( auth('admin')->user()->role, ['branch', 'employee']) || (auth('admin')->user()->role == 'employee' && auth()->user()->parent_id != '0' )) {
        //
        if (auth('admin')->user()->role == 'branch') {
            $branch_id = auth('admin')->id();
        } else {
            $branch_id = auth('admin')->user()->parent_id;
        }
        $orders = Order::whereHas('BranchData', function($q)use($branch_id){
            $q->where('admin_id', $branch_id);
        })->latest();
        } else {
            $orders = Order::whereNotNull('id');

        }
            ///////////////////////////
            // $search=[];


        $search = array();
        if (Request()->has('serial') && Request()->get('serial') != '') {
            $serial = Request()->get('serial');
            $search['serial'] = $serial;
            $orders = $orders->where('serial'  ,$serial);
        }
        if (Request()->has('user_id') && Request()->get('user_id') != '') {
            $user_id = Request()->get('user_id');
            $search['user_id'] = $user_id;
            $orders = $orders->where('user_id'  ,$user_id);
        }
        if (Request()->has('driver_id') && Request()->get('driver_id') != '') {
            $driver_id = Request()->get('driver_id');
            $search['driver_id'] = $driver_id;
            $orders = $orders->where('driver_id'  ,$driver_id);
        }
        if ($request->has('date_from') && $request->get('date_from') != '') {
            $date_from = Carbon::parse($request->get('date_from') );
            $search['date_from'] = $request->get('date_from');
            $orders = $orders->whereDate('day_date', '>=', $date_from);
            if (!$request->has('date_to') || $request->get('date_to') == '') {
                $orders = $orders->whereDate('day_date', '=', $date_from);
            }
        }
        if ($request->has('date_to') && $request->get('date_to') != '') {
            $date_to = Carbon::parse($request->get('date_to') );
            $search['date_to'] = $request->get('date_to');
            $orders = $orders->whereDate('day_date', '<=', $date_to);
        }
        if (Request()->has('id') && Request()->get('id') != '') {
            $id = Request()->get('id');
            $search['id'] = $id;
            $orders = $orders->where('id'     ,$id);
        }

        if (Request()->has('user') && Request()->get('user') != '') {
            $user = Request()->get('user');
            $search['user'] = $user;
            $orders = $orders->wherehas('User', function($q) use ($user){
                $q->where('name'     , 'LIKE', '%'.$user.'%')
                ->Orwhere('phone'     , 'LIKE', '%'.$user.'%');
            });
        }
        if (Request()->has('service') && Request()->get('service') != '') {
            $service = Request()->get('service');
            $search['service'] = $service;
            $orders = $orders->where('service_id'     ,$service);
        }
        if (Request()->has('driver') && Request()->get('driver') != '') {
            $driver = Request()->get('driver');
            $search['driver'] = $driver;
            $orders = $orders->where('driver_id'     ,$driver);
        }
        if (Request()->has('status') && Request()->get('status') != '') {
            $status = Request()->get('status');
            $search['status'] = $status;
            $orders = $orders->where('status'     ,$status);
        }
        if (Request()->has('orderBy') && Request()->get('orderBy') != '') {
            $orderBy = Request()->get('orderBy');
            $search['orderBy'] = $orderBy;
            $orders = $orders->orderBy($orderBy, 'asc');
        }else{
            $orders = $orders->orderBy('id', 'desc');

        }
        if (Request()->has('excel') && Request()->get('excel') != '') {
            $orders = $orders->get();
            return Excel::download(new GeneralExport('admin.reports.orders-excel', $orders), 'orders-'.Carbon::now()->toDateString().'.xlsx');
        }
        $orders = $orders->paginate(40);
        $title = 'الحجوزات';

        return view('admin.orders.index', compact('orders', 'title' ,'search'));
    }
    public function today(Request $request)
    {
        // $orders = Order::latest();
      //////////////////// branch or admin
      if (in_array( auth('admin')->user()->role, ['branch', 'employee']) || (auth('admin')->user()->role == 'employee' && auth()->user()->parent_id != '0' )) {
        //
        if (auth('admin')->user()->role == 'branch') {
            $branch_id = auth('admin')->id();
        } else {
            $branch_id = auth('admin')->user()->parent_id;
        }
        $orders = Order::whereDate('created_at', Carbon::today())->whereIn('status', ['init', 'driver_on_the_way', 'washing_car'])->whereHas('BranchData', function($q)use($branch_id){
            $q->where('admin_id', $branch_id);
        })->latest();
        } else {
            $orders = Order::whereDate('created_at', Carbon::today())->whereIn('status', ['init', 'driver_on_the_way', 'washing_car']);

        }
            ///////////////////////////
            // $search=[];


        $search = array();
        if (Request()->has('serial') && Request()->get('serial') != '') {
            $serial = Request()->get('serial');
            $search['serial'] = $serial;
            $orders = $orders->where('serial'  ,$serial);
        }
        if (Request()->has('user_id') && Request()->get('user_id') != '') {
            $user_id = Request()->get('user_id');
            $search['user_id'] = $user_id;
            $orders = $orders->where('user_id'  ,$user_id);
        }
        if (Request()->has('driver_id') && Request()->get('driver_id') != '') {
            $driver_id = Request()->get('driver_id');
            $search['driver_id'] = $driver_id;
            $orders = $orders->where('driver_id'  ,$driver_id);
        }
        if ($request->has('date_from') && $request->get('date_from') != '') {
            $date_from = Carbon::parse($request->get('date_from') );
            $search['date_from'] = $request->get('date_from');
            $orders = $orders->whereDate('day_date', '>=', $date_from);
            if (!$request->has('date_to') || $request->get('date_to') == '') {
                $orders = $orders->whereDate('day_date', '=', $date_from);
            }
        }
        if ($request->has('date_to') && $request->get('date_to') != '') {
            $date_to = Carbon::parse($request->get('date_to') );
            $search['date_to'] = $request->get('date_to');
            $orders = $orders->whereDate('day_date', '<=', $date_to);
        }
        if (Request()->has('id') && Request()->get('id') != '') {
            $id = Request()->get('id');
            $search['id'] = $id;
            $orders = $orders->where('id'     ,$id);
        }

        if (Request()->has('user') && Request()->get('user') != '') {
            $user = Request()->get('user');
            $search['user'] = $user;
            $orders = $orders->wherehas('User', function($q) use ($user){
                $q->where('name'     , 'LIKE', '%'.$user.'%')
                ->Orwhere('phone'     , 'LIKE', '%'.$user.'%');
            });
        }
        if (Request()->has('service') && Request()->get('service') != '') {
            $service = Request()->get('service');
            $search['service'] = $service;
            $orders = $orders->where('service_id'     ,$service);
        }
        if (Request()->has('driver') && Request()->get('driver') != '') {
            $driver = Request()->get('driver');
            $search['driver'] = $driver;
            $orders = $orders->where('driver_id'     ,$driver);
        }
        if (Request()->has('status') && Request()->get('status') != '') {
            $status = Request()->get('status');
            $search['status'] = $status;
            $orders = $orders->where('status'     ,$status);
        }
        if (Request()->has('orderBy') && Request()->get('orderBy') != '') {
            $orderBy = Request()->get('orderBy');
            $search['orderBy'] = $orderBy;
            $orders = $orders->orderBy($orderBy, 'asc');
        }else{
            $orders = $orders->orderBy('id', 'desc');

        }
        if (Request()->has('excel') && Request()->get('excel') != '') {
            $orders = $orders->get();
            return Excel::download(new GeneralExport('admin.reports.orders-excel', $orders), 'orders-'.Carbon::now()->toDateString().'.xlsx');
        }
        $orders = $orders->paginate(40);
        $title = 'الحجوزات';

        return view('admin.orders.today', compact('orders', 'title' ,'search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة حجز';
        return view('admin.orders.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreOrderRequest $request)
    {
        $this->register($request);
        // return view('admin.orders.add');
        return redirect()->back()->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Order $order)
    {
        $title = 'عرض حجز';
        return view('admin.orders.show', compact('order', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $order = Order::find($id);
        $title = 'تعديل حجز';
        return view('admin.orders.edit', compact('order', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateOrderRequest $request, $id)
    {

        $order = Order::find($id);
        $this->UpdateRecords($order, $request);
        return redirect()->back()->with('success', 'data updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Order $order)
    {
        $order->forceDelete();
        return 'success';
    }
    public function GTimes(Request $r)
    {
        $day = $r->get('day_date');
        $times = $this->getTimes($r);
        return view('admin.orders.times', compact('times'));
    }
    public function GTimesPost(Request $r)
    {
        // return $r->all();
        $day = $r->get('day_date');
        $data = ['day_date' => $r->get('day_date')];
        $order = Order::find($r->get('order_id'));
        if (!$this->checkAvT($r, $r->start_time)) {
            return back()->with('error', 'عفوا هذا الموعد غير متاح حاليا.');
        }
        $start = $r->get('start_time');
        $service_id = $r->get('service_id');
        $service = Service::find($service_id);
        $data['start_time']= Carbon::parse($start)->format('H:i:s');
        $startTime= Carbon::parse($start);
        $stime = ($startTime->hour * 60) + $startTime->minute;
        $etime = $stime + $service->take_minutes;
        $data['end_time'] = CarbonInterval::minutes($etime)->cascade()->format('%H:%I:00');
        $order->update($data);
        return back()->with('success', 'تم تغيير موعد الحجز بنجاح');
    }
    public function getTimes(Request $request)
    {
        $service_id = $request->get('service_id');
        $minutes = Service::find($service_id)->take_minutes;
        $day_date = $request->get('day_date');
        $city_id = '';
        // return Carbon::now()->format('Y-m-d H:i:m');
        if ($request->has('city_id') && $request->city_id) {
            $city_id = $request->get('city_id');
        }
        $s_t=getSettingValue('start_time');
        // if (!Carbon::parse($day_date)->gt(Carbon::today())) {
        //     $s_t_h=Carbon::parse(getSettingValue('start_time'))->format('H');
        //     // $s_t_i_s=Carbon::parse(getSettingValue('start_time'))->format('i:s');
        //     // $s_t_i_s=Carbon::parse($sh->start_time)->format('i:s');
        //     $s_t_i_s=Carbon::now()->format('i:s');
        //     $n_t = Carbon::now()->format('H:i').':00';
        //     $n_t_h = Carbon::now()->format('H');
        //     if ($n_t_h > $s_t_h) {
        //         $s_t = $n_t_h . ':'.$s_t_i_s;
        //     }
        //     // return $n_t_h;
        //     // if ($n_t_h > Carbon::parse(getSettingValue('end_time'))->format('H') || Carbon::parse($day_date)->lt(Carbon::today())) {
        //     //     return response()->json([
        //     //         'data'   => [
        //     //             'times' => [],
        //     //         ],
        //     //         'message'   => 'success',
        //     //         'code'      => getMsgCode('success')
        //     //     ]);
        //     // }
        // }
        // shifts
        $times = [];
         foreach (Shift::orderBy('start_time', 'asc')->get() as $sh) {
            //
            $s_t = $sh->start_time;
            /*if (!Carbon::parse($day_date)->gt(Carbon::today())) {
                $s_t_h=Carbon::parse($sh->start_time)->format('H');
                $s_t_i_s=Carbon::parse($sh->start_time)->format('i:s');
                $n_t = Carbon::now()->format('H:i').':00';
                $n_t_h = Carbon::now()->format('H');
                if ($n_t_h > $s_t_h) {
                    $s_t = $n_t_h . ':'.$s_t_i_s;
                }
                // return $s_t;
                if ($n_t_h > Carbon::parse($sh->end_time)->format('H') || Carbon::parse($day_date)->lt(Carbon::today())) {
                    continue;
                }
            }*/
            //
             $times = array_merge($times, $this->checkTime($s_t, $sh->end_time, $minutes,$day_date, $city_id, $service_id, $request) );
         }
        // $times = $this->checkTime($s_t, getSettingValue('end_time'), $minutes,$day_date, $city_id, $service_id, $request);
        return $times;
    }

    public function checkTime($start = '09:00:00', $end = '22:00:00', $period = 60, $day_date, $city_id = '', $service_id = '', Request $request)
    {
        $day_date= Carbon::parse($day_date);
        $startTime= Carbon::parse($start);
        $stime = ($startTime->hour * 60) + $startTime->minute;
        $endTime= Carbon::parse($end);
        $etime = ($endTime->hour * 60) + $endTime->minute;
        $orders = Order::withTrashed()->whereDate('day_date', $day_date)->where('status', '<>', 'completed');
        // $drivers_count = Driver::where('active', '1')->whereDoesntHave('Vacation', function($q)use($day_date){$q->whereDate('day_date', $day_date);});
        // shift
        $shift = Shift::whereTime('start_time', $start)->whereTime('end_time', $end)->first();
        if (!$shift) {
            $shift = Shift::whereTime('start_time', '<=', $start)->whereTime('end_time', $end)->first();
            if (!$shift) {
                return [];
            }

        }
        // shift
        $drivers_count = Driver::where('active', '1')->where('shift_id', $shift->id)
                                ->whereDoesntHave('Vacation', function($q)use($day_date){
                                    $q->whereDate('day_date', $day_date);
                                });
        if ($city_id != '') {
            $orders = $orders->where('city_id', $city_id);
            // $orders = $orders->where('city_id', $city_id);
            $drivers_count = $drivers_count->where('zone_id', $city_id);
        }
        if ($service_id != '') {
            $orders = $orders->where('service_id', $service_id);
            $drivers_count = $drivers_count->where('service_id', $service_id);
        }
        $orders = $orders/*->where('city_id', $city_id)*/->whereNotNull('end_time')->get();
        $drivers_count = $drivers_count->count();
        $c = floor(($etime - $stime) / $period);
        $p = [];
        for ($i=0; $i < $c; $i++) {
            // here if check if available peroids or not
            $p[$i][] = $i * $period + $stime;
            $p[$i][] = $i * $period + $stime + $period;
        }
        $filter = [];
        $ii = 0;
        foreach ($p as $point) {
            $flag = false;
            if ($orders->count() == 0 ) {
                $flag = true;
            }
            $c_driver_count = 0;
            // foreach ($orders as $order) {
            //     if (($point[0] <= $order->start && $point[1] <= $order->start) || ($point[0] >= $order->end && $point[1] >= $order->end)) {
            //         // $flag = true;
            //     }else{
            //         // $flag = false;
            //         // break;
            //         $c_driver_count++;
            //     }
            // }
            $c_driver_count = $orders->where('start_time', Carbon::parse(CarbonInterval::minutes($point[0])->cascade()->format('%H:%I:00') )->format('H:i:s'))->count();

            // return dd($drivers_count);
            if($drivers_count > $c_driver_count){
                $flag = true;
            }else{
                $flag = false;
            }
            if ($flag) {
                $time_1 = Carbon::parse(CarbonInterval::minutes($point[0])->cascade()->format('%H:%I:00') )->format('h:i a');
                $time_2 = Carbon::parse(CarbonInterval::minutes($point[1])->cascade()->format('%H:%I:00') )->format('h:i a');
                // n
                if (!Carbon::parse($day_date)->gt(Carbon::today()) && Carbon::now()->format('H:i:s') >= Carbon::parse(CarbonInterval::minutes($point[0])->cascade()->format('%H:%I:00') )->format('H:i:s')) {
                    // $filter[$ii++] = [$time_1 , $time_2];
                }else{
                    $filter[$ii++] = [$time_1 , $time_2];

                }
                // n
                // $filter[$ii++] = [$time_1 , $time_2];
            }
        }
        $res = $filter;
        return $res;
    }


    public function checkAvT(Request $request , $tim)
    {
        $service_id = $request->get('service_id');
        $minutes = Service::find($service_id)->take_minutes;
        $day_date = $request->get('day_date');
        $city_id = '';
        if ($request->has('city_id') && $request->city_id) {
            $city_id = $request->get('city_id');
        }
        $ap = new AppInfoController;

        // shifts
        $times = [];
         foreach (Shift::get() as $sh) {
             $times = array_merge($times, $ap->checkTimeT($sh->start_time, $sh->end_time, $minutes,$day_date, $city_id, $service_id, $request) );
         }
        // $times = $ap->checkTimeT($s_t, getSettingValue('end_time'), $minutes,$day_date, $city_id, $service_id, $request);
        if (in_array($tim, $times)) {
            return true;
        }
        return false;
    }

    // items
    public function Itemcreate()
    {
        $title = 'اضافة منتج';
        return view('admin.orders.add-item', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function Itemstore(Request $request)
    {
        $order = Order::findOrfail($request->order_id);
        $data = $request->all();
        if ($order->OrderItem()->where('product_id',$request->product_id)->count() > 0) {
            return redirect()->back()->with('warning', 'هذا المنتج موجود بالفعل');

        }
        $pro = Product::find($request->product_id);
                if ($pro->discount && $pro->discount > 0) {
                    $price = $pro->price / 100 * (100- (int)$pro->discount);
                } else {
                    $price = $pro->price;
                }
                $data['price'] = $price;
        $order->OrderItem()->create($data);
        $this->recalculateOrder($order->id);
        return redirect()->back()->with('success', 'data added successfully');
    }



    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function Itemedit($id)
    {
        $item = OrderItem::find($id);
        $title = 'تعديل المنتج';
        return view('admin.orders.edit-item', compact('item', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function Itemupdate(Request $request, $id)
    {

        $item = OrderItem::find($id);
        $data = $request->all();
        $pro = Product::find($request->product_id);
                if ($pro->discount && $pro->discount > 0) {
                    $price = $pro->price / 100 * (100- (int)$pro->discount);
                } else {
                    $price = $pro->price;
                }
                $data['price'] = $price;
        $item->update($data);
        $this->recalculateOrder($item->order_id);
        return redirect()->back()->with('success', 'data updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function Itemdestroy($id)
    {
        $order_id = OrderItem::find($id)->order_id;
        OrderItem::find($id)->delete();
        $this->recalculateOrder($order_id);
        return 'success';
    }
    public function recalculateOrder($id)
    {
        $order = Order::find($id);
        $pricelist = PriceList::where('service_id', $order->service_id)->where('size', $order->Car->size)->first();
        if ($pricelist) {
            $total = $pricelist->price;
        } else {
            $total = 0;
        }

        $price = 0;
        $price_m = 0;
        $pricem = 0;
        $o_price = 0;
        $discount = 0;
            foreach ($order->OrderItem()->get() as $item) {
                $pro = $item->Product()->first();
                if ($pro->discount && $pro->discount > 0) {
                    $price = $pro->price / 100 * (100- (int)$pro->discount);
                    $dis_price = $pro->price / 100 * ((int)$pro->discount);
                    $discount = $discount + ($dis_price * $item['qty']);
                } else {
                    $price = $pro->price;
                }
                // $pricem .= ' / ' . $price;
                    $price_m += ($price * $item->qty);
                    $o_price += ($pro->price * $item->qty);
            }
        // return dd($order->total + $price_m);
        $order->update(['total' => $total + $price_m, 'original_total' => $total + $o_price, 'discount' =>  $discount]);
        $tax = (float)getSettingValue('tax');
        $total = $order->total + (($order->total / 100) * $tax);
        $order->update(['tax' => $tax, 'total' => $total ]);
        $total_price = $order->total;
        if ($order->coupon) {
            $coupon = Coupon::where('coupon', $order->coupon)
                            ->first();
            if ($coupon && $coupon->city_id && $coupon->city_id != $order->city_id) {
                $coupon = false;
            }
            if ($coupon) {

                    $percent = $coupon->amount;
                    $discount = $total_price / 100 * $percent;
                    $order->update([
                        'discount' => $order->discount + $discount,
                        // 'original_total' => $total_price,
                        'total' => $total_price - $discount,
                        'coupon_amount' => $discount,
                        ]);
            }
        }
    }
}
