<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\City;
use App\Http\Resources\Api\CityResource;
use App\Models\Brand;
use App\Http\Resources\Api\BrandResource;
use App\Http\Resources\Api\BrandModelResource;
use App\Models\Color;
use App\Http\Resources\Api\ColorResource;
use App\Http\Controllers\Admin\CityController;
use App\Mail\BillEmail;
use App\Models\Order;
use App\Models\Service;
use App\Models\Setting;
use App\Models\Driver;
use App\Models\Shift;
use App\Models\User;
use Carbon\Carbon;
use Carbon\CarbonInterval;
use Illuminate\Support\Facades\Mail;

class AppInfoController extends Controller
{
    public function payment()
    {

        $info = Setting::whereIn('key', ['cash', 'online_payment', 'android_secret_api_key', 'payment_account_type', 'ios_secret_api_key',
        'merchant_id', 'username', 'password', 'api_key'])->pluck('value', 'key')->toArray();

        return Response()->json([
                'data' => [
                    'payment_info' => $info,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function index($type = 'home')
    {

        $info = Setting::pluck('value', 'key')->toArray();
        $info['tax'] = round((float)$info['tax'], 2);

        return Response()->json([
                'data' => [
                    'info' => $info,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function cities()
    {
        $cities = City::whereIn('parent', ['0', ''])->get();
        $cities = CityResource::collection($cities);
        return response()->json([
            'data'   => [
                'cities' => $cities,
            ],
            'message'   => 'success',
            'code'      => getMsgCode('success')
        ]);
    }
    public function colors()
    {
        $colors = Color::get();
        $colors = ColorResource::collection($colors);
        return response()->json([
            'data'   => [
                'colors' => $colors,
            ],
            'message'   => 'success',
            'code'      => getMsgCode('success')
        ]);
    }
    public function brands()
    {
        $brands = Brand::get();
        $brands = BrandResource::collection($brands);
        return response()->json([
            'data'   => [
                'brands' => $brands,
            ],
            'message'   => 'success',
            'code'      => getMsgCode('success')
        ]);
    }
    public function brandmodels($id)
    {
        $brand_models = Brand::find($id);
        $brand_models = $brand_models->BrandModel()->get();
        $brand_models = BrandModelResource::collection($brand_models);
        return response()->json([
            'data'   => [
                'brand_models' => $brand_models,
            ],
            'message'   => 'success',
            'code'      => getMsgCode('success')
        ]);
    }
    public function checkPoint(Request $request)
    {
        $lat = $request->get('latitude');
        $long = $request->get('longitude');
        $city_c = new CityController;
        $res = 0;
        $cities = City::get();
        $item = null;
        $city = null;
        foreach ($cities as $item) {
            $resu = $city_c->checkP($item->id, $lat , $long);
            if ($resu == true) {
                if (Driver::where('zone_id', $item->id)->count() > 0) {
                    $res = 1;
                    $city = $item;
                }
                break;
            }
        }
        if ($res) {
            $city = new CityResource($city);
        }
        return response()->json([
            'data'   => [
                'result' => $res,
                'city' => $city,
            ],
            'message'   => 'success',
            'code'      => getMsgCode('success')
        ]);
    }
    public function checkPointForZone(Request $request)
    {
        $lat = $request->get('latitude');
        $long = $request->get('longitude');
        $city_c = new CityController;
        $res = 0;
        $cities = City::whereHas('DriverZone')->get();
        $item = null;
        $city = null;
        foreach ($cities as $item) {
            $resu = $city_c->checkP($item->id, $lat , $long);
            if ($resu == true) {
                $res = 1;
                $city = $item;
                break;
            }
        }
        return $city;
    }
    public function getTimes(Request $request)
    {
        $service_id = $request->get('service_id');
        $minutes = Service::find($service_id)->take_minutes;
        $day_date = $request->get('day_date');
        $city_id = '';
        // return Carbon::now()->format('Y-m-d H:i:m');
        if ($request->has('city_id') && $request->city_id) {
            $city_id = $request->get('city_id');
        }
        $s_t=getSettingValue('start_time');
        // if (!Carbon::parse($day_date)->gt(Carbon::today())) {
        //     $s_t_h=Carbon::parse(getSettingValue('start_time'))->format('H');
        //     // $s_t_i_s=Carbon::parse(getSettingValue('start_time'))->format('i:s');
        //     // $s_t_i_s=Carbon::parse($sh->start_time)->format('i:s');
        //     $s_t_i_s=Carbon::now()->format('i:s');
        //     $n_t = Carbon::now()->format('H:i').':00';
        //     $n_t_h = Carbon::now()->format('H');
        //     if ($n_t_h > $s_t_h) {
        //         $s_t = $n_t_h . ':'.$s_t_i_s;
        //     }
        //     // return $n_t_h;
        //     // if ($n_t_h > Carbon::parse(getSettingValue('end_time'))->format('H') || Carbon::parse($day_date)->lt(Carbon::today())) {
        //     //     return response()->json([
        //     //         'data'   => [
        //     //             'times' => [],
        //     //         ],
        //     //         'message'   => 'success',
        //     //         'code'      => getMsgCode('success')
        //     //     ]);
        //     // }
        // }
        // shifts
        $times = [];
         foreach (Shift::orderBy('start_time', 'asc')->get() as $sh) {
            //
            $s_t = $sh->start_time;
            /*if (!Carbon::parse($day_date)->gt(Carbon::today())) {
                $s_t_h=Carbon::parse($sh->start_time)->format('H');
                $s_t_i_s=Carbon::parse($sh->start_time)->format('i:s');
                $n_t = Carbon::now()->format('H:i').':00';
                $n_t_h = Carbon::now()->format('H');
                if ($n_t_h > $s_t_h) {
                    $s_t = $n_t_h . ':'.$s_t_i_s;
                }
                // return $s_t;
                if ($n_t_h > Carbon::parse($sh->end_time)->format('H') || Carbon::parse($day_date)->lt(Carbon::today())) {
                    continue;
                }
            }*/
            //
             $times = array_merge($times, $this->checkTime($s_t, $sh->end_time, $minutes,$day_date, $city_id, $service_id, $request) );
         }
        // $times = $this->checkTime($s_t, getSettingValue('end_time'), $minutes,$day_date, $city_id, $service_id, $request);
        $times = $this->arrangArr($times);
        return response()->json([
            'data'   => [
                'times' => $times,
            ],
            'message'   => 'success',
            'code'      => getMsgCode('success')
        ]);
    }

    public function checkTime($start = '09:00:00', $end = '22:00:00', $period = 60, $day_date, $city_id = '', $service_id = '', Request $request)
    {
        $day_date= Carbon::parse($day_date);
        $startTime= Carbon::parse($start);
        $stime = ($startTime->hour * 60) + $startTime->minute;
        $endTime= Carbon::parse($end);
        $etime = ($endTime->hour * 60) + $endTime->minute;
        $orders = Order::withTrashed()->whereDate('day_date', $day_date)->where('status', '<>', 'completed');
        // $drivers_count = Driver::where('active', '1')->whereDoesntHave('Vacation', function($q)use($day_date){$q->whereDate('day_date', $day_date);});
        // shift
        $shift = Shift::whereTime('start_time', $start)->whereTime('end_time', $end)->first();
        if (!$shift) {
            $shift = Shift::whereTime('start_time', '<=', $start)->whereTime('end_time', $end)->first();
            if (!$shift) {
                return [];
            }

        }
        // shift
        $drivers_count = Driver::where('active', '1')->where('shift_id', $shift->id)
                                ->whereDoesntHave('Vacation', function($q)use($day_date){
                                    $q->whereDate('day_date', $day_date);
                                });
        $zone = $this->checkPointForZone($request);
        if ($city_id != '') {
            $orders = $orders->where('city_id', $city_id);
            // $orders = $orders->where('city_id', $city_id);
            $drivers_count = $drivers_count->where('zone_id', $city_id);
        }
        if ($zone) {
            // $orders = $orders->where('city_id', $city_id);
            // $drivers_count = $drivers_count->where('zone_id', $zone->id);
        }
        if ($service_id != '') {
            $orders = $orders->where('service_id', $service_id);
            $drivers_count = $drivers_count->where('service_id', $service_id);
        }
        $orders = $orders/*->where('city_id', $city_id)*/->whereNotNull('end_time')->get();
        $drivers_count = $drivers_count->count();
        // echo $drivers_count;
        $c = floor(($etime - $stime) / $period);
        $p = [];
        for ($i=0; $i < $c; $i++) {
            // here if check if available peroids or not
            $p[$i][] = $i * $period + $stime;
            $p[$i][] = $i * $period + $stime + $period;
        }
        $filter = [];
        $ii = 0;
        foreach ($p as $point) {
            $flag = false;
            if ($orders->count() == 0 ) {
                $flag = true;
            }
            $c_driver_count = 0;
            // foreach ($orders as $order) {
            //     if (($point[0] <= $order->start && $point[1] <= $order->start) || ($point[0] >= $order->end && $point[1] >= $order->end)) {
            //         // $flag = true;
            //     }else{
            //         // $flag = false;
            //         // break;
            //         $c_driver_count++;
            //     }
            // }
            $c_driver_count = $orders->where('start_time', Carbon::parse(CarbonInterval::minutes($point[0])->cascade()->format('%H:%I:00') )->format('H:i:s'))->count();
            // return dd($drivers_count);
        // echo $drivers_count . ': '.Carbon::parse(CarbonInterval::minutes($point[0])->cascade()->format('%H:%I:00') )->format('h:i a').' :'.$c_driver_count.' . ';
            if($drivers_count > $c_driver_count){
                $flag = true;
            }else{
                $flag = false;
            }
            if ($flag) {
                $time_1 = Carbon::parse(CarbonInterval::minutes($point[0])->cascade()->format('%H:%I:00') )->format('h:i a');
                $time_2 = Carbon::parse(CarbonInterval::minutes($point[1])->cascade()->format('%H:%I:00') )->format('h:i a');
                // n
                if (!Carbon::parse($day_date)->gt(Carbon::today()) && Carbon::now()->format('H:i:s') >= Carbon::parse(CarbonInterval::minutes($point[0])->cascade()->format('%H:%I:00') )->format('H:i:s')) {
                    // $filter[$ii++] = [$time_1 , $time_2];
                }else{
                    $filter[$ii++] = [$time_1 , $time_2];

                }
                // n
                // $filter[$ii++] = [$time_1 , $time_2];
            }
        }
        $res = $filter;
        return $res;
    }
    public function checkTimeT($start = '09:00:00', $end = '22:00:00', $period = 60, $day_date, $city_id = '', $service_id = '', Request $request)
    {
        $day_date= Carbon::parse($day_date);
        $startTime= Carbon::parse($start);
        $stime = ($startTime->hour * 60) + $startTime->minute;
        $endTime= Carbon::parse($end);
        $etime = ($endTime->hour * 60) + $endTime->minute;
        $orders = Order::withTrashed()->whereDate('day_date', $day_date)->where('status', '<>', 'completed');
        // $drivers_count = Driver::where('active', '1')->whereDoesntHave('Vacation', function($q)use($day_date){$q->whereDate('day_date', $day_date);});
        // shift
        $shift = Shift::whereTime('start_time', $start)->whereTime('end_time', $end)->first();
        if (!$shift) {
            $shift = Shift::whereTime('start_time', '<=', $start)->whereTime('end_time', $end)->first();
            if (!$shift) {
                return [];
            }

        }
        // shift
        $drivers_count = Driver::where('active', '1')->where('shift_id', $shift->id)
                                ->whereDoesntHave('Vacation', function($q)use($day_date){
                                    $q->whereDate('day_date', $day_date);
                                });
        $zone = $this->checkPointForZone($request);
        if ($city_id != '') {
            $orders = $orders->where('city_id', $city_id);
            // $orders = $orders->where('city_id', $city_id);
            $drivers_count = $drivers_count->where('zone_id', $city_id);
        }
        if ($zone) {
            // $orders = $orders->where('city_id', $city_id);
            // $drivers_count = $drivers_count->where('zone_id', $zone->id);
        }
        if ($service_id != '') {
            $orders = $orders->where('service_id', $service_id);
            $drivers_count = $drivers_count->where('service_id', $service_id);
        }
        $orders = $orders/*->where('city_id', $city_id)*/->whereNotNull('end_time')->get();
        $drivers_count = $drivers_count->count();
        $c = floor(($etime - $stime) / $period);
        $p = [];
        for ($i=0; $i < $c; $i++) {
            // here if check if available peroids or not
            $p[$i][] = $i * $period + $stime;
            $p[$i][] = $i * $period + $stime + $period;
        }
        $filter = [];
        $ii = 0;
        foreach ($p as $point) {
            $flag = false;
            if ($orders->count() == 0 ) {
                $flag = true;
            }
            $c_driver_count = 0;
            // foreach ($orders as $order) {
            //     if (($point[0] <= $order->start && $point[1] <= $order->start) || ($point[0] >= $order->end && $point[1] >= $order->end)) {
            //         // $flag = true;
            //     }else{
            //         // $flag = false;
            //         // break;
            //         $c_driver_count++;
            //     }
            // }
            $c_driver_count = $orders->where('start_time', Carbon::parse(CarbonInterval::minutes($point[0])->cascade()->format('%H:%I:00') )->format('H:i:s'))->count();

            // return dd($drivers_count);
            if($drivers_count > $c_driver_count){
                $flag = true;
            }else{
                $flag = false;
            }
            if ($flag) {
                $time_1 = Carbon::parse(CarbonInterval::minutes($point[0])->cascade()->format('%H:%I:00') )->format('h:i a');
                $time_2 = Carbon::parse(CarbonInterval::minutes($point[1])->cascade()->format('%H:%I:00') )->format('h:i a');
                // n
                if (!Carbon::parse($day_date)->gt(Carbon::today()) && Carbon::now()->format('H:i:s') >= Carbon::parse(CarbonInterval::minutes($point[0])->cascade()->format('%H:%I:00') )->format('H:i:s')) {
                    // $filter[$ii++] = [$time_1 , $time_2];
                    // 11:00:00  10:00:00
                    // 11:00:00  11:15:00
                    // $filter[] = $time_1;
                }else{
                    $filter[] = $time_1;

                }
                // n
                // $filter[] = $time_1;
            }
        }
        $res = $filter;
        return $res;
    }
    // public function checkTimeT($start = '09:00:00', $end = '22:00:00', $period = 60, $day_date, $city_id = '', $service_id = '', Request $request)
    // {
    //     $day_date= Carbon::parse($day_date);
    //     $startTime= Carbon::parse($start);
    //     $stime = ($startTime->hour * 60) + $startTime->minute;
    //     $endTime= Carbon::parse($end);
    //     $etime = ($endTime->hour * 60) + $endTime->minute;
    //     $orders = Order::withTrashed()->whereDate('day_date', $day_date)->where('status', '<>', 'completed');
    //     $drivers_count = Driver::where('active', '1');
    //     $zone = $this->checkPointForZone($request);
    //     if ($city_id != '') {
    //         $orders = $orders->where('city_id', $city_id);
    //         $drivers_count = $drivers_count->where('zone_id', $city_id);
    //     }
    //     if ($zone) {
    //         // $orders = $orders->where('city_id', $city_id);
    //         // $drivers_count = $drivers_count->where('zone_id', $zone->id);
    //     }
    //     if ($service_id != '') {
    //         $orders = $orders->where('service_id', $service_id);
    //         $drivers_count = $drivers_count->where('service_id', $service_id);
    //     }
    //     $orders = $orders/*->where('city_id', $city_id)*/->whereNotNull('end_time')->get();
    //     $drivers_count = $drivers_count->count();
    //     $c = floor(($etime - $stime) / $period);
    //     $p = [];
    //     for ($i=0; $i < $c; $i++) {
    //         // here if check if available peroids or not
    //         $p[$i][] = $i * $period + $stime;
    //         $p[$i][] = $i * $period + $stime + $period;
    //     }
    //     $filter = [];
    //     $ii = 0;
    //     foreach ($p as $point) {
    //         $flag = false;
    //         if ($orders->count() == 0 ) {
    //             $flag = true;
    //         }
    //         $c_driver_count = 0;
    //         foreach ($orders as $order) {
    //             if (($point[0] <= $order->start && $point[1] <= $order->start) || ($point[0] >= $order->end && $point[1] >= $order->end)) {
    //                 // $flag = true;
    //             }else{
    //                 // $flag = false;
    //                 // break;
    //                 $c_driver_count++;
    //             }
    //         }
    //         // return dd($drivers_count);
    //         if($drivers_count > $c_driver_count){
    //             $flag = true;
    //         }else{
    //             $flag = false;
    //         }
    //         if ($flag) {
    //             $time_1 = Carbon::parse(CarbonInterval::minutes($point[0])->cascade()->format('%H:%I:00') )->format('h:i a');
    //             $time_2 = Carbon::parse(CarbonInterval::minutes($point[1])->cascade()->format('%H:%I:00') )->format('h:i a');
    //             $filter[] = $time_1;
    //         }
    //     }
    //     $res = $filter;
    //     return $res;
    // }

    public function DeleteTrashedOrders()
    {
        $orders = Order::onlyTrashed()->where('w_f_payment', '<>', '1')->get()->where('updated_at_stamp', '<', Carbon::now()->subMinutes(5)->timestamp);
        foreach ($orders as $order) {
            // send notification
            $user = $order->User()->first();
            if( $user->lang == 'ar')
            {
                $title = "spray" ;
                $content = "عفوا مدة انشاء الطلب انتهت."  ;

            }else{
                $title = "spray";
                $content = "Order Creation time out" ;
            }
            $data2 = [
                'order' => new \stdClass,
                'title_ar' => 'Spray',
                'title_en' => 'Spray',
                'content_ar' => "عفوا مدة انشاء الطلب انتهت.",
                'content_en' => "Order Creation time out",
                'type' => 'temp_order_expired',
            ];
            $token = $user->PlayerId()->pluck('player_id')->toArray();
            FCMController::Push($title, $content,$token,$data2, 'temp_order_expired');
        }
        $orders = Order::onlyTrashed()->whereIn('id', $orders->pluck('id')->toArray() );
        $orders->forceDelete();
        return 'success';
    }

    public function arrangArr($r)
    {

        $rr = $this->bubbleSort($r);

        $rt = [];
        foreach ($this->bubbleSort2($rr) as $k => $t)
        {
            foreach ($r as $n)
            {
                if(strpos($n[0] , 'am') !== false)
              {
                  $aa2 = (int)str_replace(' am','', str_replace(':','',$n[0]));
              }else{
                  $aa2 = (int)str_replace(' pm','', str_replace(':','',$n[0])) + 1200 ;
                  if($aa2 >= 2400)
                  {
                      $aa2 = $aa2 - 1200;
                  }
              }
                if($aa2 == $t)
                $rt[] = $n;
            }
        }
        return $rt;


    }
    public function bubbleSort($array)
    {
        $a = [];
        $length = count($array);
     $ii = 0;
      for ($inner = 0; $inner < $length; $inner++) {

          if(strpos($array[$inner][0] , 'am') !== false)
          {
              $a2 = (int)str_replace(' am','', str_replace(':','',$array[$inner][0]));
          }else{
              $a2 = (int)str_replace(' pm','', str_replace(':','',$array[$inner][0])) + 1200 ;
              if($a2 >= 2400)
              {
                  $a2 = $a2 - 1200;
              }
          }
          $a[] = $a2;
      }

     return $a;
    }

    public function bubbleSort2($array)
    {
     if (!$length = count($array)) {
     }
     for ($outer = 0; $outer < $length; $outer++) {
      for ($inner = 0; $inner < $length; $inner++) {
       if ($array[$outer] < $array[$inner]) {
        $tmp = $array[$outer];
        $array[$outer] = $array[$inner];
        $array[$inner] = $tmp;
       }
      }
     }
      return $array;
    }

    public function TestBillMail($id)
    {
        $order = Order::find($id);
        $user = User::where('email', 'madar.developer@gmail.com')->first();
        Mail::to($user)->send(new BillEmail($order->id));
    }
}
