<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class UpdateDriverRequest extends FormRequest
{
    /**
     * Determine if the driver is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $driver = $this->route('driver');
        return [
            'name'            => 'required|max:255',
            // 'last_name'             => 'required|max:255',
            'email'         => 'nullable|email|unique:drivers,email,'.$driver->id.'|max:255',
            'phone'         => 'unique:drivers,phone,'.$driver->id.'|regex:/(5)[0-9]{8}/',
            'password'      => 'nullable|max:255',
            'image'         => 'nullable|image',
        ];
    }
}
