@extends('admin.layout.app')
@section('style')
<style>
    .deleted-row{
        background-color: red;
    }
    .deleted-row td{
        color:#fff;
    }
</style>
@endsection
@section('header')
<li>
    {{--  <div class="add-btn">
        <a href="{{ url('/dashboard/orders/create') }}" type="button"
    class="btn btn-custom btn-rounded waves-effect waves-light w-md m-b-5"> <i class="fa fa-check"></i> اضافة
    </a>
    </div> --}}
</li>
@endsection
@section('content')


<!-- Page-Title -->

<div class="row">

    <div class="col-sm-12">
        <div class="card-box">
            <form action="" method="get">
                <div class="row">
                    <div class="col-md-12 part-top">
                        <div class="row">

                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="row">


                            <div class="col-lg-2">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" name="user"
                                                value="{{(array_key_exists('user', $search))? $search['user'] : ''}}"
                                                class="form-control" placeholder=" اسم العميل">
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="col-lg-2">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" name="id"
                                                value="{{(array_key_exists('id', $search))? $search['id'] : ''}}"
                                                class="form-control" placeholder="  رقم الحجز ">
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="col-lg-2">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" name="date_from"
                                                value="{{(array_key_exists('date_from', $search))? $search['date_from'] : ''}}"
                                                class="form-control datepicker" autocomplete="off" placeholder="  التاريخ من">
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="col-lg-2">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" name="date_to"
                                                value="{{(array_key_exists('date_to', $search))? $search['date_to'] : ''}}"
                                                class="form-control datepicker" autocomplete="off" placeholder="  التاريخ الي">
                                        </div>
                                    </div>

                                </div>
                            </div>



                            <div class="col-lg-2">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            {!! Form::select("status",array_merge(['' => 'اختر
                                            الحالة'],OrderStatus()),(array_key_exists('status', $search))?
                                            $search['status'] :
                                            null,['class'=>"form-control  "])!!}
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="col-lg-2">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            @php
                                                $ar = [
                                                    '' => 'ترتيب بواسطة',
                                                    'start_time' => 'وقت تنفيذ الطلب',
                                                    'created_at' => 'المضاف حديثا',
                                                    // 'updated_at' => '',
                                                ];
                                            @endphp
                                            {!! Form::select("orderBy",$ar,(array_key_exists('orderBy', $search))?
                                            $search['orderBy'] :
                                            null,['class'=>"form-control  "])!!}
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="col-lg-2">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            {!! Form::select("service",Services(),(array_key_exists('service', $search))?
                                            $search['service'] :
                                            null,['class'=>"form-control  "])!!}
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="col-lg-2">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            {!! Form::select("driver",Drivers('اختر السائق'),(array_key_exists('driver', $search))?
                                            $search['driver'] :
                                            null,['class'=>"form-control  "])!!}
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="col-lg-2">
                                    <button type="button"
                                        onclick="$(this).closest('form').find('#excel').remove(); $(this).closest('form').submit();"
                                        class="btn btn-block btn-sm btn-success waves-effect waves-light b-t-10 b-b-10"><i
                                            class="fa fa-search"></i> بحث</button>
                            </div>

                            <div class="col-lg-2">
                                <div class="form-horizontal">
                                    <a href="{{url('/dashboard/orders')}}"
                                        class="btn btn-block btn-sm btn-success waves-effect waves-light b-t-10 b-b-10"><i
                                            class="fa fa-trash"></i> مسح خيارات البحث</a>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="row">

    <div class="col-sm-12">
        <div class="card-box text-left">
            <div class="row">

                <div class="col-lg-12">
                    <div class="box-tebal">
                        {{--  'user_id' , 'car_id' , 'driver_id' , 'original_total' , 'total' , 'discount' , 'status' ,
                        'payment_type' , 'rate'  --}}
                        <div role="tabpanel" class="tab-pane " style="overflow-x: scroll;">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    @php
                                    $i = 1;
                                    @endphp
                                    <tr>

                                        <th>#</th>
                                        <th>رقم الحجز </th>
                                        <th> اسم العميل </th>
                                        <th> رقم جوال العميل </th>
                                        {{--  <th>   مكان الحجز </th>  --}}
                                        <th> نوع الخدمة </th>
                                        <th> نوع السياره </th>
                                        <th> اسم السائق </th>
                                        <th> رقم جوال السائق </th>
                                        <th> تاريخ تنفيذ الحجز </th>
                                        <th> الوقت</th>
                                        <th> الحاله </th>
                                        <th> المبلغ المستحق </th>
                                        {{--  <th>  وقت الحجز </th>
                                        <th> الخصم </th> --}}
                                        <th> طريقه الدفع  </th>
                                        <th> تاريخ انشاء الحجز </th>
                                        <th> التقييم </th>
                                        <th> الملاحظات </th>
                                        <th> العمليات </th>


                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach($orders as $item)

                                    <tr style="" id="id-{{$i}}" class="{{($item->deleted_at)? 'deleted-row' : ''}}">
                                        <td>{{$i++}} </td>
                                        <td>{{$item->id }} </td>
                                        <td>{{$item->User->name ?? ''}} </td>
                                        <td>{{$item->User->phone ?? ''}} </td>
                                        {{--  <td>{{$item->}} </td> --}}
                                        <td>{{$item->Service->name ?? ''}} </td>
                                        <td>{{$item->Car->name ?? ''}} </td>
                                        <td>
                                            {!! Form::model($item, ['url' => route('orders.update', $item->id), 'method' => 'PATCH']) !!}
                                            {!! Form::select("driver_id",Drivers('اختر السائق'),null,['class'=>"form-control change-driver"])!!}
                                            {!! Form::close() !!}
                                        </td>
                                        <td>{{$item->Driver->phone ?? ''}} </td>
                                        <td>{{$item->day_date ?? ''}} </td>
                                        <td>
                                            {{\Carbon\Carbon::parse($item->start_time)->format('h:i a') ?? ''}}
                                            <br/> الي {{\Carbon\Carbon::parse($item->end_time)->format('h:i a') ?? ''}}
                                            @if (in_array($item->status, ['init', 'pending']))
                                            <button class="btn btn-danger ch-t" data-action="{{route('get-times').'?service_id='.$item->service_id.'&car_id='.$item->car_id.'&city_id='.$item->city_id.'&order_id='.$item->id}}" data-toggle="modal" data-target="#exampleModal1">تغيير موعد الحجز</button>

                                            @endif
                                        </td>
                                        {{-- <td>{{getStatus($item->status, 'ar')}} </td> --}}
                                        <td>

                                            {!! Form::model($item, ['url' => route('orders.update', $item->id), 'method' => 'PATCH']) !!}
                                            {!! Form::select("status",OrderStatus('اختر الحالة'),null,['class'=>"form-control change-driver"])!!}
                                            {!! Form::close() !!}
                                        </td>
                                        <td>{{$item->total}} </td>
                                        <td>
                                            {{$item->payment_type}}
                                            @if ($item->transaction_id)
                                                <br>
                                                <span class="badge success">
                                                    {{$item->transaction_id}}
                                                </span>
                                            @endif
                                        </td>
                                        <td>{{$item->created_at}} </td>
                                        <td>
                                            @if ($item->rate)
                                            <ul style="list-style: none; padding: 0; width: 13rem;">

                                                @for ($i = 0; $i < (int)$item->rate; $i++)
                                                <li style="display: inline-block;">

                                                    <i data-feather="star" style="color: orange;"></i>
                                                </li>
                                                @endfor
                                            </ul>

                                            @else
                                                لا يوجد تقييم
                                            @endif
                                        </td>
                                        <td>
                                            {!! $item->notes !!}
                                            <button type="button" class="btn btn-primary add-note" data-action="{{route('orders.update', $item->id)}}" data-toggle="modal" data-target="#exampleModal">اضافة ملاحظة</button>
                                        </td>


                                        <td class="btns">
                                            <a href="{{route('orders.destroy',$item)}}" type="button" title="حذف" id="delete-btn"
                                                class="btn btn-danger delete-btn  waves-effect waves-light m-b-5 btn-xs">
                                                <i class="fa fa-times"></i> </a>
                                            <a href="{{route('orders.edit',$item)}}" type="button" title="تعديل"
                                                class="btn btn-info  waves-effect waves-light m-b-5 btn-xs">
                                                <i class="fa fa-pencil"></i> </a>
                                            <a href="/dashboard/orders/{{$item->id}}" type="button" title="عرض"
                                                class="btn btn-info   waves-effect waves-light m-b-5 btn-xs"> <i
                                                    class="fa fa-eye"></i> </a>

                                        </td>
                                    </tr>
                                    @endforeach




                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div><!-- end col -->
</div>
<!-- end row -->
<div class="col-sm-12">
    {{ $orders->appends($search)->links() }}
</div>


<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">اضافة ملاحظه</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                {!!Form::open( ['url' => '/dashboard/orders/' ,'method' => 'PATCH','files' =>
                true,'id'=>'note-form']) !!}


                <div class="card-box">
                    <div class="row">


                        <p class="custom-label-centerd text-left">  </p>

                        <div class="col-lg-12">
                            <div class="form-group">
                                {{-- <label class=""> الملاحظه *</label> --}}
                                <div class=" append">
                                    {!! Form::textarea('notes', null, ['class' => 'form-control', 'required' => '', 'placeholder' => 'الملاحظه *']) !!}
                                </div>
                            </div>
                        </div>


                        <div class="text-center">
                            <button class="btn btn-primary waves-effect waves-light" type="submit"> حفظ
                            </button>
                        </div>
                    </div>


                </div>
                {!!Form::close() !!}
            </div>
            <div class="modal-footer">
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="exampleModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModal1Label"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModal1Label">تغيير موعد الحجز</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                {!!Form::open( ['url' => '/dashboard/orders/' ,'method' => 'POST','files' =>
                true,'id'=>'ch-form']) !!}


                <div class="card-box">
                    <div class="row">


                        <p class="custom-label-centerd text-left">  </p>

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label class=""> اختر اليوم *</label>
                                <div class=" append">
                                    <input type="text" name="day_date" value="{{(array_key_exists('date_from', $search))? $search['date_from'] : ''}}"
                                                class="form-control datepicker day_date_ch" autocomplete="off" placeholder="  التاريخ ">
                                </div>
                            </div>
                        </div>

                        <div id="times"></div>
                    </div>


                </div>
                {!!Form::close() !!}
            </div>
            <div class="modal-footer">
            </div>
        </div>
    </div>
</div>


@endsection
@section('script')

<script>
    $(document).on('change', '.change-driver', function() {
       $(this).closest('form').submit();
    });
    $(document).on('change', '.day_date_ch', function() {
        console.log('ff');
       $.get($(this).closest('form').attr('action') + '&day_date='+ $(this).val())
       .done(function(res){
           $('#times').html(res);
       })
       .fail(function(){})
    });
    $(document).on('click', '.add-note', function() {
       $('#note-form').attr('action', $(this).attr('data-action'));
    });
    $(document).on('click', '.ch-t', function() {
       $('#ch-form').attr('action', $(this).attr('data-action'));
    });
</script>

@endsection
