<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Feedback;
use App\Models\Admin;
use Notification;
use App\Notifications\GeneralNotification;

class FeedbackController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        $this->middleware('Permission:feedbacks_show'    , ['only' => 'index', 'show']);
        $this->middleware('Permission:feedbacks_add'     , ['only' => 'create', 'store']);
        $this->middleware('Permission:feedbacks_edit'    , ['only' => 'edit', 'update']);
        $this->middleware('Permission:feedbacks_delete'  , ['only' => 'destroy']);
    }
    public function index()
    {
        $items = Feedback::latest();
        $search = array();
        if (Request()->has('name') && Request()->get('name') != '') {
            $name = Request()->get('name');
            $search['name'] = $name;
            $items = $items->where('name'     , 'LIKE', '%'.$name.'%');
        }
        if (Request()->has('phone') && Request()->get('phone') != '') {
            $phone = Request()->get('phone');
            $search['phone'] = $phone;
            $items = $items->where('phone'     , 'LIKE', '%'.$phone.'%');
        }
        $items = $items->paginate(20);
        $title = 'المراسلات';
        return view('admin.feedbacks.index', compact('items', 'title', 'search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show( $id)
    {
        $title = 'عرض منطقة';
        $item = Feedback::findOrfail($id);
        return view('admin.feedbacks.show', compact('item', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $item = Feedback::find($id);
        $item->update($request->all() );
        return redirect()->back()->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Feedback $item)
    {
        if ($item->image) {
            @unlink(public_path('/cdn/'.$item->image));
        }
        $item->delete();
        return 'success';
    }
    public function logout()
    {
        Auth::logout();
        return redirect('/login');
    }
}
