<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateServiceRequest;
use App\Http\Requests\Admin\StoreServiceRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\ServiceOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Service;
use Auth;
use Excel;
use App\Exports\GeneralExport;
use Carbon\Carbon;

class ServiceController extends Controller
{
    use ServiceOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    
    public function __construct()
    {
        $this->middleware('Permission:services_show'    , ['only' => 'index', 'show']);
        $this->middleware('Permission:services_add'     , ['only' => 'create', 'store']);
        $this->middleware('Permission:services_edit'    , ['only' => 'edit', 'update']);
        $this->middleware('Permission:services_delete'  , ['only' => 'destroy']);
    }
    public function index()
    {
        $title = 'الخدمات';
        if (in_array( auth('admin')->user()->role, ['branch', 'employee']) || (auth('admin')->user()->role == 'employee' && auth()->user()->parent_id != '0' )) {
            // 
            if (auth('admin')->user()->role == 'branch') {
                $branch_id = auth('admin')->id();
            } else {
                $branch_id = auth('admin')->user()->parent_id;
            }
                $services = Service::whereHas('BranchData', function($q) use( $branch_id ){
                    $q->where('admin_id', $branch_id);
                })->get();
            } else {
                $services = Service::latest();
                
            }
            $search = array();
            if (Request()->has('id') && Request()->get('id') != '') {
                $id = Request()->get('id');
                $search['id'] = $id;
                $services = $services->where('id',$id);
            }
            if (Request()->has('name') && Request()->get('name') != '') {
                $name = Request()->get('name');
                $search['name'] = $name;
                $services = $services->where('structure_no'     , 'LIKE', '%'.$name.'%')->orWhere('name'     , 'LIKE', '%'.$name.'%');
            }
            if (Request()->has('excel') && Request()->get('excel') != '') {
                $services = $services->get();
                return Excel::download(new GeneralExport($services,'admin.reports.services-excel'), 'services-'.Carbon::now()->toDateString().'.xlsx');
            }
            $services = $services->paginate(40);
        return view('admin.services.index', compact('services', 'title' , 'search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة ';
        return view('admin.services.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreServiceRequest $request)
    {
        $this->register($request);
        return redirect('/dashboard/services')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Service $service)
    {
        $title = 'عرض ';
        return view('admin.services.show', compact('service', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $service = Service::find($id);
        $title = 'تعديل ';
        return view('admin.services.edit', compact('service', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateServiceRequest $request, $id)
    {
      
        $service = Service::find($id);
        $this->UpdateRecords($service, $request);
      
        return redirect('dashboard/services');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Service $service)
    {
        if ($service->form_image) {
            @unlink(public_path('/cdn/'.$service->form_image));
        }
        $service->delete();
        return 'success';
    }
}
