<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use LaravelFCM\Message\OptionsBuilder;
use LaravelFCM\Message\PayloadDataBuilder;
use LaravelFCM\Message\PayloadNotificationBuilder;
use FCM;
use FCMGroup;
use GuzzleHttp\Client;
use Google\Auth\ApplicationDefaultCredentials;
use Google\Auth\CredentialsLoader;
use Google\Auth\HttpHandler\HttpHandlerFactory;
use Google\Auth\OAuth2;


class FCMController extends Controller
{
    /*public static function Push($title, $content,$token,$data, $activity = '')
    {
        // $data2 = [
        //     'notification' => [
        //         'click_action' => $activity,
        //         'body' => $content,
        //         'title' => $title,
        //         'icon' => ''
        //     ],
        //     'data' =>$data
        // ];
        try{
            $notificationBuilder = new PayloadNotificationBuilder();
            $notificationBuilder->setTitle($title)
                                ->setBody($content)
                                ->setSound('sound')
                                ->setChannelId('com.madar_al_reyadah.algeri_client')
                                // ->setChannelName('busstecc_driver_channel')
                                ->setClickAction($activity);
                                // ->setBadge('badge');

            $notification = $notificationBuilder->build();
            $dataBuilder = new PayloadDataBuilder();
            $dataBuilder->addData($data);

            $data = $dataBuilder->build();
            $downstreamResponse = FCM::sendTo($token, null, $notification, $data);
            return $downstreamResponse;
        }catch(\Exception $e){
            return true;
        }
    }*/
    
    // public static function newPush($title, $body, $token, $data, $activity = '')
    public static function Push($title, $content,$token,$data, $activity = '') 
    {
        // 
        $keyPath = public_path('sprayapp-2dddd-firebase-adminsdk-3j3hp-4e2595e5d3.json');

        // Define the required scope
        $scopes = ['https://www.googleapis.com/auth/firebase.messaging'];
        
        // Load the service account key file
        $jsonKey = json_decode(file_get_contents($keyPath), true);
        
        // Create OAuth2 credentials object
        $client = new Client();
        $credentials = CredentialsLoader::makeCredentials($scopes, $jsonKey);
        $httpHandler = HttpHandlerFactory::build($client);
        
        // Refresh the token
        $credentials->fetchAuthToken($httpHandler);
        
        // Get the access token
        $accessToken = $credentials->getLastReceivedToken()['access_token'];
        // 
        
        $url = 'https://fcm.googleapis.com/v1/projects/sprayapp-2dddd/messages:send';

        

        $headers = [
            'Authorization' => 'Bearer ' . $accessToken,
            'Content-Type' => 'application/json',
        ];
        // $data = [];
        $payloadTemplate = [
                'message' => [
                    'notification' => [
                        
                        'body' => $content,
                        'title' => $title
                        ],
                    'data' => $data,
                    'android' => [
                        'notification' => [
                            'click_action' => 'OPEN_ACTIVITY_1'
                        ]
                    ],
                    'apns' => [
                        'payload' => [
                            'aps' => [
                                'category' => 'NEW_MESSAGE_CATEGORY'
                            ]
                        ]
                    ]
                ]
            ];
            // dd($payloadTemplate);
            $result = [];
            foreach ($token as $tok) {
                $payload = $payloadTemplate;
                $payload['message']['token'] = $tok;
            
                try{
                    
                    // Send the POST request
                    $response = $client->post($url, [
                        'headers' => [
                            'Authorization' => 'Bearer ' . $accessToken,
                            'Content-Type' => 'application/json'
                        ],
                        'json' => $payload
                    ]);
                    // $response = json_decode($response->getBody());
                    $result[] = $response;
                }catch(\Exception $e){
                    
                }
            
            }
            // dd($result);
            return '';

    }
}