<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BrandModel extends Model
{
    protected $table='brand_models';
    protected $fillable = [
        'name_ar' , 'name_en' , 'brand_id'
    ];

    protected $appends = ['name'];
   
    public function getNameAttribute()
    {
        if(Request()->header('lang') == 'ar'){ 
            return $this->name_ar;
        } else {
            return $this->name_en;
        }
    }
    public function Brand()
    {
        return $this->belongsTo(Brand::class, 'brand_id');
    }
}
