<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\SoftDeletes;

class City extends Model
{
    use SoftDeletes;
    protected $table='cities';
    protected $fillable = [
        'name_ar' , 'name_en' , 'parent', 'latitude', 'longitude', 'address', 'polygon', 'polygon_data',
    ];

    protected $appends = ['name'];
    
    public function Parent()
    {
        return $this->belongsTo(City::class, 'parent');
    }
    
    public function getNameAttribute()
    {
        if(Request()->header('lang') == 'ar'){ 
            return $this->name_ar;
        } else {
            return $this->name_en;
        }
    }
    public function User()
    {
        return $this->HasMany(User::class, 'city_id');
    }
    public function DriverZone()
    {
        return $this->HasMany(Driver::class, 'zone_id');
    }
}
