<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Service extends Model
{
    use SoftDeletes;
    protected $table='services';
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name_ar', 'name_en', 'image', 'price' , 'discount', 'active', 'take_minutes', 'description'
    ];
    
    protected $appends = ['name'];
    
    public function getNameAttribute()
    {
        if(Request()->header('lang') == 'ar'){ 
            return $this->name_ar;
        } else {
            return $this->name_en;
        }
    }
    public function getImageAttribute($img)
    {
        return url('/cdn'). '/'. $img;
    }
    public function PriceList()
    {
        return $this->HasMany(PriceList::class, 'service_id');
    }
    public function Driver()
    {
        return $this->HasMany(Driver::class, 'service_id');
    }
}
