<?php
namespace App\Traits\Admin;

use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Driver;
use Mail;
use DB;

trait DriverOperations
{


    /**
     * Register a New .
     *
     * @param $request
     * @return \App\
     */
    public function register ($request)
    {
        $data = $request->all();
        if ($request->hasFile('image')) {
            $data['image'] = uploadFile($request);
        }
        if ($request->has('password') && $data['password'] != '') {
            $data['password'] = bcrypt($data['password']);
        }
        DB::beginTransaction();
        $Driver = Driver::create($data);
        if ($request->has('zones') && $request->zones != []) {
            foreach ($request->zones as $ke) {
                $Driver->DriverZone()->create(['zone_id' => $ke]);
            }
        }
        if ($request->has('shifts') && $request->shifts != []) {
            foreach ($request->shifts as $ke) {
                $Driver->DriverShift()->create(['shift_id' => $ke]);
            }
        }
        DB::commit();
        return $Driver;
    }


    /**
     * Update Record
     * @param $truck
     * @param $request
     */
    public function UpdateRecords(Driver $Driver,$request)
    {
        $data = $request->all();
        if ($request->hasFile('image')) {
            @unlink(public_path('/cdn/'.$Driver->image));
            //
            $data['image'] = uploadFile($request);
        }
        if ($request->has('password') && $data['password'] != '') {
            $data['password'] = bcrypt($data['password']);
        }else{
            unset($data['password']);
        }
        $Driver->DriverZone()->delete();
        if ($request->has('zones') && $request->zones != []) {
            foreach ($request->zones as $ke) {
                $Driver->DriverZone()->create(['zone_id' => $ke]);
            }
        }
        $Driver->DriverShift()->delete();
        if ($request->has('shifts') && $request->shifts != []) {
            foreach ($request->shifts as $ke) {
                $Driver->DriverShift()->create(['shift_id' => $ke]);
            }
        }
        $Driver->update($data);
        return $Driver;
    }

}
