<?php
namespace App\Traits\Admin;

use App\Http\Controllers\Api\FCMController;
use App\Notifications\GeneralNotification;
use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\Driver;
use App\Models\PriceList;
use DB;
use Carbon\Carbon;
use App\Models\Admin;
use App\Notifications\AdminNotification;

trait OrderOperations
{
  

    /**
     * Register a New .
     *
     * @param $request
     * @return \App\
     */
    public function register ($request)
    {
        $data = $request->all();
        if ($request->hasFile('image')) {
            $data['image'] = uploadImage($request->file('image'));
        }
        if ($request->has('time')) {
            $data['time'] = Carbon::parse($request->get('time'));
        }
        if ($request->has('time_form')) {
            $data['time_form'] = Carbon::parse($request->get('time_form'));
        }
        if ($request->has('time_to')) {
            $data['time_to'] = Carbon::parse($request->get('time_to'));
        }
        if ($request->has('pick_up_date')) {
            $data['pick_up_date'] = Carbon::parse($request->get('pick_up_date'));
        }
        if ($request->has('delivered_order')) {
            $data['delivered_order'] = Carbon::parse($request->get('delivered_order'));
        }
        ////////////////////////// serial start/////////////////////////////

        DB::beginTransaction();
        $Order = Order::create($data);
        $s = str_replace(' ', '',date('Y m').$Order->id);
        $serial = 'mx-'.$s;
        $Order->update(['serial' => $serial, 'serial_no' => (int)$s]);
        //////////////////////// the date of creation order
        $Order->OrderLog()->create([
            'status' => 'new',
            'details' =>  trans('words.'.'new')
        ]);
        $admin = Admin::first();
        $message = 'تم اضافة حجز جديد : '.$Order->id;
        if($admin)
        {
            $admin->notify(new GeneralNotification($message, '/dashboard/orders/'.$Order->id ) );
        }
        
        if (in_array( auth('admin')->user()->role, ['branch', 'employee']) || (auth('admin')->user()->role == 'employee' && auth()->user()->parent_id != '0' )) {
            // 
            if (auth('admin')->user()->role == 'branch') {
                $branch_id = auth('admin')->id();
            } else {
                $branch_id = auth('admin')->user()->parent_id;
            }
            $Order->BranchData()->create(['admin_id' => $branch_id]);
        }
        DB::commit();
        return $Order;
    }


    /**
     * Update Record
     * @param $truck
     * @param $request
     */
    public function UpdateRecords(Order $Order,$request)
    {
        // $data = $request->only(['driver_id', 'status']);
        $data = $request->only(['driver_id', 'status', 'payment_type', 'service_id']);
        if($request->has('status') && $request->status == 'canceled')
        {
            $data['driver_id'] = null;
        }
        if ($request->has('notes')) {
            if ($Order->notes) {
                $data['notes'] = $Order->notes . ' <br>' . $request->get('notes');
            }else{
                $data['notes'] = $request->get('notes');

            }
        }
        if ($request->hasFile('image')) {
            @unlink(public_path('/cdn/'.$Order->image));
            // 
            $data['image'] = uploadImage($request->file('image'));
        }
        $Order->update($data);

        return $Order;
    }
    /**
     * delete Record
     * @param $truck
     * @param $request
     */
    public function DeleteRecord($id)
    {
        //
    }
}
