<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSubscribesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('subscribes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->unsignedBigInteger('service_id')->nullable();
            $table->foreign('service_id')->references('id')->on('services');
            $table->integer('cleans')->nullable();
            $table->double('price', 15, 2)->default(0.0);
            $table->double('original_total', 15, 2)->default(0.0);
            $table->double('discount', 15, 2)->default(0.0);
            $table->double('total_price', 15, 2)->default(0.0);
            $table->string('image')->nullable();
            $table->string('coupon')->nullable();
            $table->double('coupon_amount', 15, 2)->default(0.0);
            $table->float('tax', 4, 2)->default(0.0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('subscribes');
    }
}
