@extends('admin.layout.app')
@section('style')
@endsection
@section('content')
<!-- Page-Title -->

<div class="row">

    <div class="col-sm-12">
        <div class="card-box">
            <form action="" method="get">
                <div class="row">

                    <div class="col-md-12">
                        <div class="row">
                            
                            <div class="col-lg-2">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" name="title"
                                                value="{{(array_key_exists('title', $search))? $search['title'] : ''}}"
                                                class="form-control" placeholder=" الكود ">
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="col-lg-2">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" name="date_from"
                                                value="{{(array_key_exists('date_from', $search))? $search['date_from'] : ''}}"
                                                class="form-control datepicker" autocomplete="off" placeholder="  التاريخ الانشاء من">
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="col-lg-2">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" name="date_to"
                                                value="{{(array_key_exists('date_to', $search))? $search['date_to'] : ''}}"
                                                class="form-control datepicker" autocomplete="off" placeholder="  التاريخ الانشاء الي">
                                        </div>
                                    </div>

                                </div>
                            </div>
                            
                            <div class="col-lg-2">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            @php
                                                $ar = [
                                                    '' => 'حالة الكوبون ',
                                                    'expired' => 'منتهي',
                                                    'active' => 'ساري',
                                                    // 'updated_at' => '',
                                                ];
                                            @endphp
                                            {!! Form::select("status",$ar,(array_key_exists('status', $search))? $search['status'] : null,['class'=>"form-control  "])!!}
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="col-lg-2">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            {!! Form::select("city", CitiesSearch(),(array_key_exists('city', $search))?
                                            $search['city'] :
                                            null,['class'=>"form-control  "])!!}
                                        </div>
                                    </div>

                                </div>
                            </div>


                            <div class="col-lg-2">
                                    <button type="submit"
                                        class="btn btn-block btn-sm btn-success waves-effect waves-light b-t-10 b-b-10"><i
                                            class="fa fa-search"></i> بحث</button>
                            </div>

                            <div class="col-lg-2">
                                <div class="form-horizontal">
                                    <a href="{{url('/dashboard/coupons')}}"
                                        class="btn btn-block btn-sm btn-success waves-effect waves-light b-t-10 b-b-10"><i
                                            class="fa fa-trash"></i> مسح خيارات البحث</a>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="row">
    
    <div class="col-sm-12">
        <div class="card-box table-responsive">
            <div class="row">

                <div class="col-md-12">
                    <div class="tab-content">

                        
                        <div role="tabpanel" class="tab-pane active" id="customers">
                            <table id="datatable-0" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th> الكوبون</th>
                                        <th>النسبة</th>
                                        <th> الحد الاقصي للخصم </th>
                                        <th> عدد المستفيدين </th>
                                        <th> عدد مرات الاستخدام </th>
                                        <th>الحالة</th>
                                        <th>تعديل</th>
                                        <th>حذف</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach($coupons as $item)
                                    <tr>
                                        <td> {{$item->coupon}} </td>
                                        <td> {{$item->amount}} % </td>
                                        <td> {{$item->max}} </td>
                                        <td> {{$item->benefits}} </td>
                                        <td>{{$item->Order()->count()}}</td>
                                        <td> {{($item->active == 1) ? 'نشط' : 'غير نشط'}} </td>
                                        
                                        <td><a href="{{route('coupons.edit',$item)}}"><i class="fa fa-pencil  m-r-10" style="color: #188ae2;"></i> تعديل</a></td>
                                        <td> <a href="{{route('coupons.destroy',$item)}}" id="delete-btn" ><i class="fa fa-trash-o m-r-10" style="color: #5b69bc;"></i> حذف</a></td>
                                    </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>

                    </div>
                    
                </div>
            </div>
            
        </div>
    </div><!-- end col -->
</div>
{!! $coupons->appends($search)->links() !!}
<!-- end row -->
@endsection
@section('script')
@endsection