<!DOCTYPE html>
<html lang="en" dir="rtl">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="A fully featured admin theme which can be used to build CRM, CMS, etc.">
    <meta name="author" content="Coderthemes">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- App Favicon -->
    <link rel="shortcut icon" href="<?php echo e(asset('/assets/images/madar-logo-dark.png')); ?>">

    <!-- App title -->
    <title> رذاذ | <?php echo e(isset($title)? $title : ''); ?></title>

    <!-- DataTables -->
    <link href="<?php echo e(asset('/adminto/assets/plugins/datatables/jquery.dataTables.min.css')); ?>" rel="stylesheet"
        type="text/css" />
    <link href="<?php echo e(asset('/adminto/assets/plugins/datatables/buttons.bootstrap.min.css')); ?>" rel="stylesheet"
        type="text/css" />
    <link href="<?php echo e(asset('/adminto/assets/plugins/datatables/fixedHeader.bootstrap.min.css')); ?>" rel="stylesheet"
        type="text/css" />
    <link href="<?php echo e(asset('/adminto/assets/plugins/datatables/responsive.bootstrap.min.css')); ?>" rel="stylesheet"
        type="text/css" />
    <link href="<?php echo e(asset('/adminto/assets/plugins/datatables/scroller.bootstrap.min.css')); ?>" rel="stylesheet"
        type="text/css" />
        <link href="/adminto/assets/plugins/switchery/switchery.min.css" rel="stylesheet" />
        <?php if(request()->url() == url('/dashboard/notifications')): ?>
        <link href="<?php echo e(asset('/select22.min.css')); ?>" rel="stylesheet" type="text/css">

        <?php else: ?>
        <link href="<?php echo e(asset('/adminto/assets/plugins/select2/dist/css/select2.css')); ?>" rel="stylesheet" type="text/css">
        <link href="<?php echo e(asset('/adminto/assets/plugins/select2/dist/css/select2-bootstrap.css')); ?>" rel="stylesheet"
            type="text/css">

        <?php endif; ?>
    <link href="/adminto/assets/plugins/toastr/toastr.min.css" rel="stylesheet" type="text/css" />

    <link href="<?php echo e(asset('/adminto/assets/plugins/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css')); ?>"
        rel="stylesheet">

    <link href="<?php echo e(asset('/adminto/assets/plugins/timepicker/bootstrap-timepicker.min.css')); ?>"
        rel="stylesheet">
        <link href="<?php echo e(asset('/adminto/assets/plugins/mjolnic-bootstrap-colorpicker/dist/css/bootstrap-colorpicker.min.css')); ?>" rel="stylesheet">
    <link
        href="//cdn.rawgit.com/Eonasdan/bootstrap-datetimepicker/e8bddc60e73c1ec2475f827be36e1957af72e2ea/build/css/bootstrap-datetimepicker.css"
        rel="stylesheet">
    <!-- App CSS -->
    <link href="<?php echo e(asset('/adminto/assets/css/bootstrap-rtl.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('/adminto/assets/css/core.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('/adminto/assets/css/components.css')); ?>" rel="stylesheet" type="text/css" />
    
    <link href="<?php echo e(asset('/adminto/assets/css/pages.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('/adminto/assets/css/menu.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('/adminto/assets/css/responsive.css')); ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo e(asset('css/font-awesome.min.css')); ?>">
    

    <link href="<?php echo e(asset('/adminto/assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css')); ?>" rel="stylesheet" />
    <!-- HTML5 Shiv and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesnt work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
        <![endif]-->

    <script src="<?php echo e(asset('/adminto/assets/js/modernizr.min.js')); ?>"></script>

    <!-- cusotm style -->
    <link href="<?php echo e(asset('/adminto/assets/css/my-style.css')); ?>" rel="stylesheet" type="text/css" />
    <style>
        .datepicker {
            direction: rtl;
        }
        #sidebar-menu ul li .menu-arrow:before {
            content: '\f107';
            font-family: 'FontAwesome';
        }
    </style>
<style type="text/css">
    #mapCanvas{
        width: 100%;
        height: 300px;
    }
</style>

<style>
    .sub-header-title-custom {
    overflow: visible;
}
.sub-header-title-custom {
    background-color: #f6f6f6 !important;
    border-right: 4px solid #04394e !important;
    color: #04394e;
}
.sub-header-title-custom ul {
    display: inline-block;
    float: left;
    list-style: none;
    padding-top: 5px;
}
.sub-header-title-custom ul li {
    display: block;
    min-width: 110px;
    text-align: center;
    padding: 0px;
}
.sub-header-title-custom h5 {
    display: inline-block;
    padding-right: 1rem;
    font-size: 17px;
}
</style>
<link rel="stylesheet" href="/myCss.css">
    <?php echo $__env->yieldContent('style'); ?>
</head>


<body class="fixed-left">

    <!-- Begin page -->
    <div id="wrapper">

        <!-- Top Bar Start -->
        <div class="topbar">

            <!-- LOGO -->
            <div class="topbar-left">
                <a href="<?php echo e(url('/dashboard')); ?>" class="logo">
                    <img class="img-responsive" src="<?php echo e(asset('/adminto/assets/images/logo.png')); ?>" style="max-height: 77px;">
                </a>
            </div>
            <!--Navigation Menu-->
            <div class="navbar navbar-default" role="navigation">
                <div class="container">

                    <!-- Page title -->
                    <ul class="nav navbar-nav navbar-left">
                        <li>
                            <button class="button-menu-mobile  ">
                                <i class="zmdi zmdi-menu"></i>
                            </button>
                        </li>
                        <li>
                            <h4 class="page-title">
                                <?php echo e((isset($title))? $title : ''); ?> </h4>
                        </li>
                    </ul>
                    <ul class="nav navbar-nav navbar-right">
                        <?php echo $__env->yieldContent('header'); ?>
                        <li>
                            <!-- Notification -->
                            <div class="notification-box">
                                <ul class="list-inline m-b-0">
                                    <li>
                                        <a href="javascript:void(0);" class="right-bar-toggle">
                                            <i class="zmdi zmdi-notifications-none"></i>
                                        </a>
                                        <div class="noti-dot">
                                            <span class="dot"></span>
                                            <span class="pulse"></span>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </li>
                    </ul>
                </div><!-- end container -->
            </div><!-- end navbar -->
        </div>
        <!-- Top Bar End -->


        <?php echo $__env->make('admin.layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="content-page">
            <!-- Start content -->
            <div class="content">
                <div class="container">

                    <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <?php endif; ?>


                    <?php echo $__env->yieldContent('content'); ?>

                    <!-- end row -->




                </div> <!-- container -->

            </div> <!-- content -->

            <footer class="footer">
            </footer>

        </div>


        <!-- ============================================================== -->
        <!-- End Right content here -->
        <!-- ============================================================== -->


        <!-- Right Sidebar -->
        <div class="side-bar right-bar">
            <a href="javascript:void(0);" class="right-bar-toggle">
                <i class="zmdi zmdi-close-circle-o"></i>
            </a>
            <h4 class="">الاشعارات</h4>
            <div class="notification-list nicescroll">
                <ul class="list-group list-no-border user-list" id="notifications">
                    <?php
                        // die();
                    ?>
                    <?php
                    $user = \App\Models\Admin::first();
                    $notifications = $user->unreadnotifications()->latest()->paginate(50);
                    ?>
                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="list-group-item <?php echo e(($item->read_at)? '' : 'active'); ?>">
                        <?php if( array_key_exists('redirect', $item->data) ): ?>
                        <a href="<?php echo e((str_contains($item->data['redirect'], '?'))? $item->data['redirect'].'&notify='.$item->id : $item->data['redirect'].'?notify='.$item->id); ?>"
                            class="user-list-item">
                            <?php else: ?>
                            <a href="#" class="user-list-item">
                                <?php endif; ?>
                                <div class="avatar">
                                    <img src="" alt="">
                                </div>
                                <div class="user-desc" alt="<?php echo e($item->data['text']); ?>" title="<?php echo e($item->data['text']); ?>">
                                    <span class="desc"><?php echo e($item->data['text']); ?></span>
                                    <span class="time"><?php echo e($item->created_at); ?></span>
                                </div>
                            </a>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </ul>
            </div>
        </div>
        <!-- /Right-bar -->

    </div>
    <!-- END wrapper -->



    <script>
        var resizefunc = [];

    </script>



    <?php if(\Request::url() != url('/dashboard') ): ?>
    <!-- jQuery  -->
    <script src="<?php echo e(asset('/adminto/assets/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/js/bootstrap-rtl.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/js/detect.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/js/fastclick.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/js/jquery.slimscroll.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/js/jquery.blockUI.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/js/waves.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/js/jquery.nicescroll.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/js/jquery.scrollTo.min.js')); ?>"></script>
    <script src="/adminto/assets/plugins/switchery/switchery.min.js"></script>

    <script src="<?php echo e(asset('/adminto/assets/plugins/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js')); ?>">
    </script>

    <script src="<?php echo e(asset('/adminto/assets/plugins/timepicker/bootstrap-timepicker.min.js')); ?>">
    </script>

    <script src="//cdnjs.cloudflare.com/ajax/libs/moment.js/2.9.0/moment-with-locales.js"></script>


    <script
        src="//cdn.rawgit.com/Eonasdan/bootstrap-datetimepicker/e8bddc60e73c1ec2475f827be36e1957af72e2ea/src/js/bootstrap-datetimepicker.js">
    </script>
    <!-- Datatables-->
    <script src="<?php echo e(asset('/adminto/assets/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/plugins/datatables/dataTables.bootstrap.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/plugins/datatables/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/plugins/datatables/buttons.bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/plugins/datatables/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/plugins/datatables/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/plugins/datatables/vfs_fonts.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/plugins/datatables/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/plugins/datatables/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/plugins/datatables/dataTables.fixedHeader.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/plugins/datatables/dataTables.keyTable.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/plugins/datatables/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/plugins/datatables/responsive.bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/plugins/datatables/dataTables.scroller.min.js')); ?>"></script>
    <?php if(request()->url() == url('/dashboard/notifications')): ?>
    <script src="/select22.min.js"></script>

    <?php else: ?>
    <script src="<?php echo e(asset('/adminto/assets/plugins/select2/dist/js/select2.min.js')); ?>" type="text/javascript"></script>

    <?php endif; ?>
    <script src="<?php echo e(asset('/adminto/assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js')); ?>"></script>

    <!-- Datatable init js -->
    <script src="<?php echo e(asset('/adminto/assets/pages/datatables.init.js')); ?>"></script>
    <!-- Toastr js -->
    <script src="/adminto/assets/plugins/toastr/toastr.min.js"></script>

    <!-- App js -->
    <script src="<?php echo e(asset('/adminto/assets/js/jquery.core.js')); ?>"></script>
    <script src="<?php echo e(asset('/adminto/assets/js/jquery.app.js')); ?>"></script>
    

    <script type="text/javascript">
        // Date Picker
        jQuery('.timepicker').timepicker({
        showMeridian: false ,
        showSeconds: true
        });
        jQuery('.datepicker').datepicker({
            format: "yyyy-mm-dd"
        });
        jQuery('.datetimepicker').datetimepicker({
            format: 'YYYY-MM-DD hh:mm:ss'
        });
        $('.start-datepicker').datepicker({
            format: 'yyyy-mm-dd'
        }).on('changeDate', function (selected) {
            var minDate = new Date(selected.date.valueOf());
            $('.end-datepicker').datepicker('setStartDate', minDate);
        });
        $('.end-datepicker').datepicker({
            format: 'yyyy-mm-dd'
        }).on('changeDate', function (selected) {
            var minDate = new Date(selected.date.valueOf());
            $('.start-datepicker').datepicker('setEndDate', minDate);
        });
        $(function () {
            $('.date-picker-month-year').datepicker({
                format: "mm-yyyy",
                viewMode: "months",
                minViewMode: "months"
            });
            $('.date-picker-year').datepicker({
                format: "yyyy",
                viewMode: "years",
                minViewMode: "years"
            });
        });
        $(document).ready(function () {
            $('#datatable').DataTable();
            $('#datatable-keytable').DataTable({
                keys: true
            });
            $('#datatable-responsive').DataTable();
            $('#datatable-scroller').DataTable({
                ajax: "<?php echo e(asset('/adminto/assets/plugins/datatables/json/scroller-demo.json')); ?>",
                deferRender: true,
                scrollY: 380,
                scrollCollapse: true,
                scroller: true
            });
            var table = $('#datatable-fixed-header').DataTable({
                fixedHeader: true
            });
        });
        TableManageButtons.init();

    </script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

    </script>
    <script>
        $("#Customer_isOwner").on("click", function () {
            var checked = $(this).is(':checked');
            if (checked) {
                $(".owner-inputs").removeClass('hidden');
            } else {
                $(".owner-inputs").addClass('hidden');
            }
        });

        $("#Customer_isSc").on("click", function () {
            var checked = $(this).is(':checked');
            if (checked) {
                $(".owner-sc").removeClass('hidden');
            } else {
                $(".owner-sc").addClass('hidden');
            }
        });

        $('#bank-plus').on('click', function () {
            if ($('.bank-plus').hasClass('hidden')) {
                $('.bank-plus').removeClass('hidden');
            } else {
                $('.bank-plus').addClass('hidden');
            }
            return false;
        });

        //$(".select2").select2();

    </script>
    <?php if(session()->has('success')): ?>
    <script type="text/javascript">
        toastr["success"]("تمت العملية بنجاح .")

        toastr.options = {
            "closeButton": false,
            "debug": false,
            "newestOnTop": false,
            "progressBar": false,
            "positionClass": "toast-top-right",
            "preventDuplicates": false,
            "onclick": null,
            "showDuration": "300",
            "hideDuration": "1000",
            "timeOut": "5000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }

    </script>
    <?php endif; ?>
    <?php if(session()->has('warning')): ?>
    <script type="text/javascript">
        toastr["warning"]("<?php echo e(session()->get('warning')); ?>")

        toastr.options = {
            "closeButton": false,
            "debug": false,
            "newestOnTop": false,
            "progressBar": false,
            "positionClass": "toast-top-right",
            "preventDuplicates": false,
            "onclick": null,
            "showDuration": "500",
            "hideDuration": "1000",
            "timeOut": "5000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }

    </script>
    <?php endif; ?>
    <?php if(session()->has('error')): ?>
    <script type="text/javascript">
        toastr["error"]("<?php echo e(session()->get('error')); ?>")

        toastr.options = {
            "closeButton": false,
            "debug": false,
            "newestOnTop": false,
            "progressBar": false,
            "positionClass": "toast-top-right",
            "preventDuplicates": false,
            "onclick": null,
            "showDuration": "500",
            "hideDuration": "1000",
            "timeOut": "5000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }

    </script>
    <?php endif; ?>
    <script>
        var deleter = {

            linkSelector: "a#delete-btn",

            init: function () {
                $(this.linkSelector).on('click', {
                    self: this
                }, this.handleClick);
            },

            handleClick: function (event) {
                event.preventDefault();

                var self = event.data.self;
                var link = $(this);

                swal({
                    title: "هل أنت متأكد؟",
                    text: "أنك تريد حذف هذه المنطقه ؟",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                }).then(function (isConfirm) {
                    if (isConfirm) {
                        var cr = $('meta[name="csrf-token"]').attr('content');
                        var o = link;
                        // alert(cr);
                        $(o).append('<i class="fa fa-spin fa-spinner"></i>');
                        $.post($(o).attr('href'), {
                            _token: cr,
                            _method: 'DELETE'
                        }, function (data) {
                            $(o).find('i').remove();
                            $(o).append('<i class="fa fa-check"></i>');
                            setTimeout(function () {
                                $(o).parent().parent().remove();
                                if (typeof cb == 'function') {
                                    cb();
                                }
                            }, 1000);
                        });
                    } else {
                        swal("تم الالغاء", "الحذف  الغي بنجاح");
                    }
                });

            },
        };

        deleter.init();

    </script>
    <script>
        var deleterfile = {

            linkSelector: "a.delete-file",

            init: function () {
                $(this.linkSelector).on('click', {
                    self: this
                }, this.handleClick);
            },

            handleClick: function (event) {
                event.preventDefault();

                var self = event.data.self;
                var link = $(this);

                swal({
                    title: "هل أنت متأكد؟",
                    text: "أنك تريد حذف هذه المنطقه ؟",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                }).then(function (isConfirm) {
                    if (isConfirm) {
                        var cr = $('meta[name="csrf-token"]').attr('content');
                        var o = link;
                        // alert(cr);
                        $(o).append('<i class="fa fa-spin fa-spinner"></i>');
                        $.post($(o).attr('href'), {
                            _token: cr,
                            _method: 'DELETE'
                        }, function (data) {
                            $(o).find('i').remove();
                            $(o).append('<i class="fa fa-check"></i>');
                            setTimeout(function () {
                                $(o).parent().parent().remove();
                                if (typeof cb == 'function') {
                                    cb();
                                }
                            }, 1000);
                        });
                    } else {
                        swal("تم الالغاء", "الحذف  الغي بنجاح");
                    }
                });

            },
        };

        deleterfile.init();

    </script>

    <script
        src="<?php echo e(asset('/adminto/assets/plugins/mjolnic-bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js')); ?>">
    </script>
    <script src="<?php echo e(asset('/adminto/assets/plugins/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js')); ?>">
    </script>
    <script>
        $('.colorpicker-default').colorpicker({
            format: 'hex'
        });
    </script>
    <script>
        jQuery('.datepicker-input').datepicker();

    </script>

    <script>
        //    loader

        $('.select2').select2();

        $(document).on('change', 'select[name=city_p]', function() {
                var o = $(this);
                    $.get("<?php echo e(url('/dashboard/get-regions')); ?>" + "/" + $(this).val(), function(data) {
                        o.closest('form').find('select[name=city_id]').html(data);
                        $('select[name=city_id]').select2();
                    });
                });

$(document).on('change', '.prt', function(){
    // alert($('.prt').val())
    if ($('.prt').val() == '' || $('.prt').val() == '0') {
        $('.m-p').addClass('hidden')

    }else{
        $('.m-p').removeClass('hidden')

    }
});
$(document).ready(function(){

if ($('.prt').val() == '' || $('.prt').val() == '0') {
        $('.m-p').addClass('hidden')

    }else{
        $('.m-p').removeClass('hidden')

    }
})

                $(document).on('change', 'select[name=city_id]', function() {
                    var o = $(this);
                    $.get("<?php echo e(url('/dashboard/get-regions')); ?>" + "/" + $(this).val(), function(data) {
                        o.closest('form').find('select[name=zone_id]').html(data);
                        $('select[name=zone_id]').select2();
                    });
                });
    </script>


    <script>

        $(document).on('click', '.load-ajax', function() {
                    var o = $(this);
                    $.get(o.attr('data-route'), function(data) {
                        $('#ajax-content').html(data);
                        jQuery('.datepicker-input').datepicker({
                                format: "yyyy-mm-dd"
                            });
                    });
                });
    </script>
    <?php endif; ?>
    <?php echo $__env->yieldContent('script'); ?>
    <script src="https://js.pusher.com/7.0/pusher.min.js"></script>
  <script>

    // Enable pusher logging - don't include this in production
    Pusher.logToConsole = false;

    var pusher = new Pusher('c86a5b09329128d0431d', {
      cluster: 'eu'
    });

    var channel = pusher.subscribe('my-channel-<?php echo e(auth("admin")->id()); ?>');
    channel.bind('general', function(data) {
    $('#notifications').prepend(`
    <li class="list-group-item active">
                        <a href="/dashboard/orders/`+data['id']+`"
                            class="user-list-item">
                                <div class="avatar">
                                    <img src="" alt="">
                                </div>
                                <div class="user-desc" alt="`+data['message']+`" title="`+data['message']+`">
                                    <span class="desc">`+data['message']+`</span>
                                    <span class="time">now</span>
                                </div>
                            </a>
                    </li>
    `);
    playSound('<?php echo e(url("/notify.wav")); ?>');
        toastr["success"](data['message'])

        toastr.options = {
            "closeButton": false,
            "debug": false,
            "newestOnTop": false,
            "progressBar": false,
            "positionClass": "toast-top-right",
            "preventDuplicates": false,
            "onclick": null,
            "showDuration": "5000",
            "hideDuration": "1000",
            "timeOut": "10000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }

    });
    function playSound(url) {
  const audio = new Audio(url);
  audio.play();
}
  </script>
  
  <script>
    //   feather.replace()

  </script>
</body>

</html>
<?php /**PATH /home/spreysa/public_html/resources/views/admin/layout/app.blade.php ENDPATH**/ ?>