<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdatePriceListRequest;
use App\Http\Requests\Admin\StorePriceListRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\PriceListOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\PriceList;
use Auth;

class PriceListController extends Controller
{
    use PriceListOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    
    public function __construct()
    {
        $this->middleware('Permission:settings_show'    , ['only' => 'index', 'show', 'only' => 'create', 'store', 'only' => 'edit', 'update', 'only' => 'destroy']);
    }
    public function index()
    {
        $all = PriceList::latest()->get();
        $prices = PriceList::latest()->get();
        $title = 'محددات الاسعار';
        return view('admin.price_lists.index', compact('prices', 'title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة ';
        
        return view('admin.price_lists.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $price = $this->register($request);
        return redirect(url('/dashboard/pricelists'))->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(PriceList $price)
    {
        $title = 'عرض ';
        return view('admin.price_lists.show', compact('price', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $price = PriceList::find($id);
        
        $title = 'تعديل ';
        return view('admin.price_lists.edit', compact('price', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $price)
    {
        // return $request->all();
        $price = PriceList::find($price);
        $this->UpdateRecords($price, $request);
        return redirect(url('/dashboard/pricelists'))->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(PriceList $price)
    {
        if ($price->image) {
            @unlink(public_path('/cdn/'.$price->image));
        }
        $price->delete();
        return 'success';
    }
}
