<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PriceList;
use App\Models\Admin;
use App\Models\Permission;
use App\Models\Role;
use App\Models\UserRole;
use App\Models\City;
use App\Models\CarType;
use App\Models\CarCarrierType;
use App\Models\CarMaker;
use App\Models\Models;
use App\Models\Color;
use App\Models\Year;
use App\Models\Setting;
use App\Models\Mission;
use App\Models\Category;

class SettingsController extends Controller
{


    public function __construct()
    {
        $this->middleware('Permission:settings_show'    , ['only' => 'index', 'store']);
    }
    

    public function PermissionGet(Request $request)
    {
        $admin_roles = UserRole::latest()->get();
        return view('admin.settings.permissions', compact('admin_roles'));
    }
    public function PermissionPost(Request $request)
    {
        $data = $request->all();
        $role = Role::create([ 'name' => $data['role']]);
        unset($data['_token']);
        unset($data['role']);
        foreach ($data as $key => $value) {
            Permission::create([ 'role_id' => $role->id, 'permission' => $key]);
        }
        
        return redirect()->back()->with('success', 'data added');
    }
    public function PermissionUpdate(Request $request, $id)
    {
        $data = $request->all();
        $role = Role::findOrfail($id);
        $role->update([ 'name' => $data['role']]);
        $role->Permission()->delete();
        unset($data['_token']);
        unset($data['role']);
        foreach ($data as $key => $value) {
            Permission::create([ 'role_id' => $role->id, 'permission' => $key]);
        }
        return redirect()->back()->with('success', 'data added');
    }
    public function PermissionDelete(Request $request, $id)
    {
        $data = $request->all();
        $item = Role::findOrfail($id);
        $item->Permission()->delete();
        $item->delete();
        return redirect()->back()->with('success', 'data deleted');
    }
    public function PermissionDeleteUser(Request $request, $id)
    {
        $data = $request->all();
        $item = UserRole::findOrfail($id);
        $item->delete();
        return redirect()->back()->with('success', 'data deleted');
    }
    public function UserRole(Request $request)
    {
        $request->validate([
            'admin_id' => 'required|exists:admins,id',
            'role_id' => 'required|exists:roles,id',
        ]);
        $data = $request->all();
        if ( UserRole::where('admin_id', $data['admin_id'])->first() ) {
            UserRole::where('admin_id', $data['admin_id'])->update(['role_id' => $data['role_id'] ]);
        }else{

            UserRole::create($data);
        }
        return redirect()->back()->with('success', 'data added');
    }



    public function AdminGet(Request $request)
    {
        return view('admin.settings.admins');
    }

    public function AdminEdit(Request $request, $id)
    {
        $admin = Admin::find($id);
        return view('admin.settings.admins-edit', compact('admin'));
    }
    public function AdminPost(Request $request)
    {
        $data = $request->all();
        $this->validate($request, [
            'email' => 'unique:admins|max:255',
            'phone' => 'unique:admins|max:255',
        ]);
        $data['password'] = bcrypt($data['password']);
        Admin::create($data);
        return redirect()->back()->with('success', 'data added');
    }
    public function AdminUpdate(Request $request, $id)
    {
        $data = $request->all();
        $item = Admin::findOrfail($id);
        $this->validate($request, [
            'email' => 'max:255|unique:admins,email,'.$item->id,
            'phone' => 'max:255|unique:admins,phone,'.$item->id,
        ]);
        if ($request->has('password') && $data['password'] != '') {
            $data['password'] = bcrypt($data['password']);
        }else{
            unset($data['password']);
        }
        if ($request->hasFile('image')) {
            $data['image'] = uploadFile($request);
        }
        $item->update($data);
        return redirect()->back()->with('success', 'data added');
    }
    public function AdminDelete(Request $request, $id)
    {
        $data = $request->all();
        $item = Admin::findOrfail($id);
        $item->delete();
        return redirect()->back()->with('success', 'data deleted');
    }
    public function regions(Request $request, $id)
    {
        $data = $request->all();
        $parent = City::where('id',$id)->first();
        // if ($parent->parent == '0') {
        //     $items = [];
        // }else{
            $items = City::where('parent',$id)->get();

        // }
        // if ($parent->parent == '0') {
        //     $items = [];
        // }else{
        //     $items = City::where('parent',$id)->get();

        // }
        return view('admin.ajax.regions', compact('items', 'parent'))->render();
    }


}
