<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Traits\Api\CardOperations;
use App\Http\Requests\Api\StoreCardRequest;
use App\Http\Resources\Api\CardResource;
use Auth;
use App\Models\User;
use App\Models\Card;

class CardController extends Controller
{
    use CardOperations;

    public function store(StoreCardRequest $request)
    {
    	$user = Auth::guard('api')->user();
        $card = $this->register($request);
        $cards = $user->Card()->get();
        $cards = CardResource::collection($cards);
    	return Response()->json([
                'data' => [
                    'cards' => $cards,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }

    public function AllCards(Request $request)
    {
        $user = Auth::guard('api')->user();
        $cards = $user->Card()->get();
        $cards = CardResource::collection($cards);
        return Response()->json([
                'data' => [
                    'cards' => $cards,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }

    public function GetCard($id)
    {
        $user = Auth::guard('api')->user();
        $card = $user->Card()->find($id);
        $card = new CardResource($card);
        return Response()->json([
                'data' => [
                    'card' => $card,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }


    public function UpdateCard(Request $request, $id)
    {
        $user = Auth::guard('api')->user();
        $card = $user->Card()->find($id);
        $this->UpdateRecords($card, $request);
        $cards = $user->Card()->get();
        $cards = CardResource::collection($cards);
        return Response()->json([
                'data' => [
                    'cards' => $cards,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }


    public function DeleteCard(Request $request, $id)
    {
        $user = Auth::guard('api')->user();
        $card = $user->Card()->find($id);
        if ($card) {
            $card->delete();
        }
        $cards = $user->Card()->get();
        $cards = CardResource::collection($cards);
        return Response()->json([
                'data' => [
                    'cards' => $cards,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
}
