<?php

namespace App\Http\Controllers\Api;

use App\Mail\Api\UserVerify as UserVerifyMail;
use App\Http\Requests\Api\UpdateUserRequest;
use App\Http\Controllers\Controller;
use App\Traits\Api\UserOperations;
use App\Http\Resources\Api\UserResource;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Feedback;
use Carbon\Carbon;
use Validator;
use Auth;
use Mail;
use DB;
// use Tymon\JWTAuth\Facades\JWTAuth;


class UserController extends Controller
{
    use UserOperations;

    public function login(Request $request)
    {

            // $code = $request->get('code');
            $email = $request->get('email');
            $code = $request->get('code');
            $phone = $request->get('phone');
            if ($request->has('phone')) {
                $credentials = ['phone' => $phone];
                // check user
                $user = User::where('phone', $phone)->where('verify_code', $code)->first();
                // if (!$user) {
                //     $user = User::create(['phone' => $phone]);
                // }
                if($user && $token = auth('api')->login($user))
                {
                    $user = auth('api')->user();
                    $user->update(['verify_code' => null]);
                    if(Request()->has('player_id') && !$user->PlayerId()->where('player_id', '=', $request->get('player_id'))->first() )
                    {
                        $user->PlayerId()->create(['player_id' => $request->player_id]);
                    }
                    $user->token = $token;
                    $user = new UserResource($user);
                    return Response()->json([
                            'data'          => [
                                'user'  => $user,
                            ],
                            'message'       => 'success',
                            'code'          => getMsgCode('success'),
                        ]);
                }
            }return Response()->json([
                        'data'   => new \stdClass,
                        'errors'       => [' '],
                        'message'       => 'authFailed',
                        'code'          => getMsgCode('authFailed'),
                    ]);
    }

    public function logout()
    {
        $user = Auth::guard('api')->user();
        if (Request()->has('player_id')) {
            $user->PlayerId()->where('player_id', '=', Request()->get('player_id'))->delete();
        }
        return Response()->json([
            'data'          => new \stdClass,
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }

    public function update(UpdateUserRequest $request)
    {
        $user = Auth::guard('api')->user();

        $this->UpdateRecords($user, $request);
        $user = User::find($user->id);
        $user->token = auth('api')->tokenById($user->id);
        $user = new UserResource($user);
        return Response()->json([
                'data' => [
                    'user' => $user
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function profile(Request $request)
    {
        $user = Auth::guard('api')->user();
        $user = new UserResource($user);
        return Response()->json([
                'data' => [
                    'user' => $user
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function notifications(Request $request)
    {
        $user = auth('api')->user();
        $notifications  = $user->unreadnotifications;
        return Response()->json([
                'data' => [
                    'notifications' => $notifications
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function notificationReaded(Request $request)
    {
        $user = auth('api')->user();
        DB::table('notifications')->where('id', Request()->get('id') )->update(['read_at' => Carbon::now() ]);
        $notifications  = $user->unreadnotifications;
        return Response()->json([
                'data' => [
                    'notifications' => $notifications
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }

    public function sendVerifyCode(Request $request)
    {
        $phone = $request->get('phone');
        // $code = '2222';//rand(1000,9999);
        $code = rand(1000,9999);
                if (!Request()->has('resend')) {

                    $user = auth('api')->user();
                    if(!$user)
                    {
                        return Response()->json([
                            'data'   => new \stdClass,
                            'errors'       => [' '],
                            'message'       => 'authFailed',
                            'code'          => getMsgCode('authFailed'),
                        ]);
                    }
                    if(User::where('phone', $phone)->where('id', '<>', $user->id)->count() > 0)
                    {
                        return Response()->json([
                                'data' => new \stdClass,
                                'errors' => ['هذا الهاتف مسجل من قبل.'],
                                'message' => 'validationErrors',
                                'code' => getMsgCode('validationErrors')
                        ]);
                    }

                }else{
                    $phone = $request->get('phone');
                    $user = User::where('phone', $phone)->first();
                    if(!$user)
                    {
                        return Response()->json([
                                'data' => new \stdClass,
                                'errors' => ['هذا الهاتف غير مسجل من قبل.'],
                                'message' => 'validationErrors',
                                'code' => getMsgCode('validationErrors')
                        ]);
                    }
                }
            $user->verify_code = $code;
            $user->save();
            try{
                $result=$this->sendSMS($phone, 'Your Spray Verification Code is:'.$code);
            }catch(\Exception $e){

            }

            return Response()->json([
                    'data' => [
                        'phone' => $phone,
                        'code' => $code
                    ],
                    'message' => 'success',
                    'code' => getMsgCode('success')
            ]);
    }
    // public function sendSMS($destinations, $message)
    // {
    //     $username = "Aljeri";		    // اسم المستخدم الخاص بك في الموقع
    //     $password = "SmSaljeri_1330"; 		// كلمة المرور الخاصة بك
    //     $destinations = $destinations; //الارقام المرسل لها  ,, يتم وضع فاصلة بين الارقام المراد الارسال لها
    //     $message = $message;      // محتوى الرسالة
    //     $sender = "JTC";         // اسم المرسل الخاص بك المفعل  في الموقع
    //     $url = "http://www.jawalbsms.ws/api.php/sendsms?user=$username&pass=$password&to=$destinations&message=$message&sender=$sender";

    //     $ch = curl_init($url); // init the curl with jawalb API url
    //     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    //     curl_setopt($ch, CURLOPT_HEADER, 0);
    //     $data = curl_exec($ch);  //run curl api call, on success curl call, $data will contain the API call response
    //     curl_close($ch);
    //     // print_r($data);

    //     return $data;
    // }

    public function phoneVerify()
    {
        $phone        = Request()->get('phone');
        $verifyData  = Request()->all();

        if ($user = User::where('verify_code',$verifyData['code'])->where('phone',$phone)->first() ){

            if( $user->update(['verify' => 1]) ){

                $user->token = auth('api')->tokenById($user->id);
                $user = new UserResource($user);
                return response()->json([
                        'data'      => [
                                'user' => $user,
                        ],
                        'message'   => 'success',
                        'code'      => getMsgCode()
                ]);

            }else{
                return response()->json([
                    'data'   => new \stdClass,
                    'errors'       => [' '],
                    'message'   => 'something went wrong',
                    'code'      => getMsgCode('somethingWrong')
                ]);
            }


        }else{
             return response()->json([
                    'data'   => new \stdClass,
                    'errors'       => [' '],
                    'message'   => 'worng phone verification number',
                    'code'      => getMsgCode('wrongPhoneVerifyNum')
            ]);
        }
    }

    public function SendVerifySms(Request $request)
    {
        $phone = $request->get('phone');
        $user = User::where('phone',$phone )->first();
        if (!$user){
            $user = User::create(['phone' => $phone]);
        }

        // send sms
        // $code = '2222';

        $code = rand(1000,9999);
        $user->update(['verify_code' => $code]);
        try{
            $result=$this->sendSMS($phone, 'Your Spray Verification Code is:'.$code);
        }catch(\Exception $e){

        }
            return response()->json([
                'data'   => [
                    'phone' => $user->phone,
                ],
                'message'   => 'success',
                'code'      => getMsgCode('success')
            ]);

    }
    public function contact(Request $request)
    {
        $data = ['message' => $request->message];
        $user = auth('api')->user();
        if ($user){
            $data['user_id'] = $user->id;
        }
        Feedback::create($data);
        return response()->json([
            'data'   => new \stdClass,
            'message'   => 'success',
            'code'      => getMsgCode('success')
        ]);

    }
    public function generateOtp(Request $request)
    {
        // $otp = 2222;
        $otp = rand(1000,9999);
        \DB::table('password_resets')->insert(['email' => $request->phone, 'token' => $otp]);
        return response()->json([
            'data'   => [
                'phone' => $request->phone
            ],
            'message'   => 'success',
            'code'      => getMsgCode('success')
        ]);

    }
    public function checkOtp(Request $request)
    {
        $row = \DB::table('password_resets')->where(['email' => $request->phone, 'token' => $request->otp])->first();
        if ($row) {
            # code...
            return response()->json([
                'data'   => new \stdClass,
                'message'   => 'success',
                'code'      => getMsgCode('success')
            ]);
        }
        return response()->json([
            'data'   => new \stdClass,
            'message'   => 'notFound',
            'code'      => getMsgCode('notFound')
        ]);

    }
    public function sendSMS($destinations, $message)
    {
        $postRequest = array(
            'body' => $message,
            'sender' => 'MADAR',
            'recipients' => [
                $destinations
            ]
        );

        $cURLConnection = curl_init('https://api.taqnyat.sa/v1/messages');
        curl_setopt($cURLConnection, CURLOPT_POSTFIELDS, json_encode($postRequest));
        curl_setopt($cURLConnection, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($cURLConnection, CURLOPT_HTTPHEADER, array(
            'Authorization: Bearer 32861ca4e71b8670e1b7d87b54723865',
            'Content-Type: application/json'
        ));

        $apiResponse = curl_exec($cURLConnection);
        curl_close($cURLConnection);

        // $apiResponse - available data from the API request
        $jsonArrayResponse = json_decode($apiResponse);
        return $jsonArrayResponse;
    }

}
