<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Resources\Json\JsonResource;

class CarResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'user_id' => $this->user_id,
            'plate_number' => $this->plate_number,
            'plate_number2' => $this->plate_number2,
            'image' => $this->image,
            'model' => $this->model,
            'color' => new ColorResource($this->Color()->first()),
            'brand' => new BrandResource($this->Brand()->first()),
            'brand_model' => new BrandModelResource($this->BrandModel()->first()),
            'size' => $this->size,
        ];
    }
}
