<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon; 

class SimpleOrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        ini_set('precision', 8);
        if(Request()->header('lang') == 'ar'){
            $lang = 'ar';
        }else{
            $lang = 'en';
        }
        return [
            'id'                        => $this->id,
            'car'                       => new CarResource($this->Car()->first()),
            'total'                     => round($this->total, 2),
            'status'                    => $this->status,
            'rate'                      => round($this->rate, 2),
            'phone'                     => $this->User->phone ?? '',
            'latitude'                  => $this->latitude,
            'longitude'                 => $this->longitude,
            'date'                      => Carbon::parse($this->day_date)->format('d M'),
            'time'                      => Carbon::parse($this->day_date. ' '.$this->start_time)->format('h:i A'),
        ];
    }
}
