<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Brand extends Model
{
    protected $table='brands';
    protected $fillable = [
        'name_ar' , 'name_en' ,
    ];

    protected $appends = ['name'];
    
    public function getNameAttribute()
    {
        if(Request()->header('lang') == 'ar'){ 
            return $this->name_ar;
        } else {
            return $this->name_en;
        }
    }
    public function BrandModel()
    {
        return $this->Hasmany(BrandModel::class, 'brand_id');
    }
}
