@extends('admin.layout.app')
@section('style')
@endsection
@section('content')
<!-- Page-Title -->


<div class="row">
    
    <div class="col-sm-12">
        <div class="card-box table-responsive">
            <div class="row">

                <div class="col-md-12">
                    <div class="tab-content">

                        
                        <div role="tabpanel" class="tab-pane active" id="customers">
                            <table id="datatable-0" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th> الكوبون</th>
                                        <th>النسبة</th>
                                        <th> الحد الاقصي للخصم </th>
                                        <th> عدد المستفيدين </th>
                                        <th> عدد مرات الاستخدام </th>
                                        <th>الحالة</th>
                                        <th>تعديل</th>
                                        <th>حذف</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach($coupons as $item)
                                    <tr>
                                        <td> {{$item->coupon}} </td>
                                        <td> {{$item->amount}} % </td>
                                        <td> {{$item->max}} </td>
                                        <td> {{$item->benefits}} </td>
                                        <td>{{$item->Order()->count()}}</td>
                                        <td> {{($item->active == 1) ? 'نشط' : 'غير نشط'}} </td>
                                        
                                        <td><a href="{{route('coupons.edit',$item)}}"><i class="fa fa-pencil  m-r-10" style="color: #188ae2;"></i> تعديل</a></td>
                                        <td> <a href="{{route('coupons.destroy',$item)}}" id="delete-btn" ><i class="fa fa-trash-o m-r-10" style="color: #5b69bc;"></i> حذف</a></td>
                                    </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>

                    </div>
                    
                </div>
            </div>
            
        </div>
    </div><!-- end col -->
</div>
<!-- end row -->
@endsection
@section('script')
@endsection