<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Product;
use App\Models\Order;
use App\Models\Service;
use App\Models\PriceList;
use App\Models\Car;
use App\Models\City;
use App\Models\Coupon;
use App\Models\Driver;
use App\Http\Resources\Api\ServiceResource;
use App\Models\AvailableDayTime;
use App\Http\Resources\Api\AvailableDayTimeResource;
use Carbon\Carbon;
use Carbon\CarbonInterval;
use Kreait\Firebase\Database;
use App\Http\Resources\Api\OrderResource;
use App\Http\Resources\Api\SingleOrderResource;
use App\Http\Resources\Api\ProductResource;
use App\Http\Resources\Api\CouponResource;
use App\Http\Controllers\Admin\CityController;
use App\Http\Resources\Api\SimpleOrderResource;
use DB;
use App\Models\Admin;
use App\Notifications\AdminNotification;

class OldOrderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user = auth('api')->user();
        $orders = $user->Order();
        
        if (Request()->has('status') && Request()->get('status') != '') {
            $status = Request()->get('status');
            if ($status != 'finished') {
                $orders = $orders->whereNotIn('status', ['finished', 'completed']);
                
            }else{
                $orders = $orders->whereIn('status', ['finished', 'completed']);

            }
        }
        $orders = $orders->paginate(20);
        $orders->data = OrderResource::collection($orders);
        return Response()->json([
            'data'          => [
                'orders'  => $orders,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function show($id)
    {
        $user = auth('api')->user();
        $order = $user->Order()->find($id);
        
        $order = new SingleOrderResource($order);
        return Response()->json([
            'data'          => [
                'order'  => $order,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function times()
    {
        $times = AvailableDayTime::get();
        $times = AvailableDayTimeResource::collection($times);
        return Response()->json([
            'data'          => [
                'times'  => $times,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function create()
    {
        $services = Service::whereHas('PriceList')->whereHas('Driver')->get();
        $services = ServiceResource::collection($services);
        $products = Product::get();
        $products = ProductResource::collection($products);
        return Response()->json([
            'data'          => [
                'services'  => $services,
                'products'  => $products,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function addProducts(Request $request)
    {
        $user = auth('api')->user();
        DB::beginTransaction();
        $order = Order::withTrashed()->find($request->get('order_id'));
        if (!$order) {
            return Response()->json([
                'data'          => new \stdClass,
                'message'       => 'sorry timeout, please start your process again',
                'code'          => getMsgCode('notAvailable'),
            ]);
        }
        $products = $request->get('products');
        $price = 0;
        $price_m = 0;
        $pricem = 0;
        $o_price = 0;
        $discount = 0;
        if (sizeof($products)) {
            foreach ($products as $item) {
                $pro = Product::find($item['id']);
                if ($pro->discount && $pro->discount > 0) {
                    $price = $pro->price / 100 * (100- (int)$pro->discount);
                    $dis_price = $pro->price / 100 * ((int)$pro->discount);
                    $discount = $discount + ($dis_price * $item['qty']);
                } else {
                    $price = $pro->price;
                }
                $pricem .= ' / ' . $price;
                $order->OrderItem()->create([
                    'product_id' => $pro->id,
                    'price' => $price,
                    'qty' => $item['qty'],
                    ]);
                    $price_m += ($price * $item['qty']);
                    $o_price += ($pro->price * $item['qty']);
            }
        }
        // return dd($order->total + $price_m);
        $order->update(['total' => $order->total + $price_m, 'original_total' => $order->original_total + $o_price, 'discount' => $order->discount + $discount]);
        $tax = (float)getSettingValue('tax');
        $total = $order->total + (($order->total / 100) * $tax);
        $order->update(['tax' => $tax, 'total' => $total, 'payment_type' => $request->get('payment_type') ]);
        $total_price = $order->total;
        if ($request->has('coupon') && $request->get('coupon') != '') {
            $coupon = Coupon::where('coupon', $request->get('coupon'))
                            ->where('active', '1')
                            ->whereDate('start_date', '<=', Carbon::now())
                            ->whereDate('end_date', '>=', Carbon::now())
                            ->first();
            if ($coupon->city_id && $coupon->city_id != $order->city_id) {
                $coupon = false;
            }
            if ($coupon) {
                if ($coupon->Order()->count() >= $coupon->benefits) {
                    $msg = 'coupon benefits ended';
                }else{
                    $percent = $coupon->amount;
                    $discount = $total_price / 100 * $percent;
                    $order->update([
                        'discount' => $order->discount + $discount,
                        // 'original_total' => $total_price,
                        'total' => $total_price - $discount,
                        'coupon' => $request->get('coupon'),
                        'coupon_amount' => $discount,
                        ]);
                }
            } else {
                $msg = 'coupon not found';
            }
        }
        // tax
        // $tax = (float)getSettingValue('tax');
        // $total = $order->total + (($order->total / 100) * $tax);
        // $order->update(['tax' => $tax, 'total' => $total]);
        $ct = $this->checkPoint($order->latitude, $order->longitude);
        // return $ct;
        if ($ct) {
                $driver = Driver::where('active', '1')->where('zone_id', $ct->id)->where('service_id', $order->service_id)
                                    ->whereDoesntHave('Order', function($o)use($order){
                                        $o->where('start_time', $order->start_time)
                                        ->where('service_id', $order->service_id)
                                        ->where('status', '<>', 'completed');
                                    })->whereDoesntHave('Vacation', function($q)use($order){
                                        $q->whereDate('day_date', $order->day_date);
                                    })->first();
                // $driver = Driver::whereHas('DriverZone',function($q)use($ct){
                //     $q->where('id', $ct->id);
                // })->first();
            if ($driver) {
                $order->update(['driver_id' => $driver->id]);
                // send notification
                if( $driver->lang == 'ar')
                {
                    $title = "spray";
                    $content = "لديك حجز جديد  #". $order->id ;

                }else{
                    $title = "spray";
                    $content = "You Have new order #".$order->id ;
                }
                $type = "new_order";
                
                $s_order = new SimpleOrderResource($order);
                $order = new SingleOrderResource($order);
                $title_ar = "spray";
                $title_en = "spray";
                $content_ar = "لديك حجز جديد  #".$order->id ;
                $content_en = "You Have new order #".$order->id ;
                $activity = "new_order";
                    $data2 = [
                        'order' => $s_order,
                        'title_ar' => $title_ar,
                        'title_en' => $title_en,
                        'content_ar' => $content_ar,
                        'content_en' => $content_en,
                        'type' => $type,
                    ];
                    $token = $driver->PlayerId()->pluck('player_id')->toArray();
                    if ($token = $driver->PlayerId()->count() > 0 ) {
                        FCMController::Push($title, $content,$token,$data2, $activity);
                    }
                    $admin = Admin::first();
                    if ($admin) {
                        $admin->notify(new AdminNotification(" حجز جديد  #".$order->id , route('orders.show',$order->id) ));
                    }
            }
        }
        $order->restore();
        if ($request->has('payment_type') && $request->has('transaction_id') && $request->payment_type == 'online') {
            if ($order) {
                if ($request->payment =='success') {
                    $order->update(['status' => 'confirmed', 'payment_type' => 'online']);
                }
            }
        }
        $order = new SingleOrderResource($order);
        DB::commit();
        return Response()->json([
            'data'          => [
                'order'  => $order
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function checkPoint($lat, $long)
    {
        $city_c = new CityController;
        $res = 0;
        $cities = City::whereHas('Parent.Parent')->get();
        $item = null;
        $city = null;
        foreach ($cities as $item) {
            $resu = $city_c->checkP($item->id, $lat , $long);
            if ($resu == true) {
                $res = 1;
                $city = $item;
                break;
            }
        }
        if (!$city) {
            $cities = City::whereHas('Parent')->get();
            foreach ($cities as $item) {
                $resu = $city_c->checkP($item->id, $lat , $long);
                if ($resu == true) {
                    $res = 1;
                    $city = $item;
                    break;
                }
            }
        }
        return $city;
    }
    public function store(Request $request)
    {
        $user = auth('api')->user();
        $data = $request->only(['day_date', 'start_time', 'service_id', 'car_id', 'latitude', 'longitude', 'address', 'city_id']);
        $start = $request->get('start_time');
        $service_id = $request->get('service_id');
        $service = Service::find($service_id);
        $data['start_time']= Carbon::parse($start)->format('H:i:s');
        $startTime= Carbon::parse($start);
        $stime = ($startTime->hour * 60) + $startTime->minute;
        $etime = $stime + $service->take_minutes;
        $data['status'] = 'pending';
        if ($request->has('car_id')) {
            $car = Car::find($request->car_id);
            if ($car) {
                $pricel = $service->PriceList()->where('size', $car->size)->first();
                $data['service_price'] = $pricel->price;
                if ($pricel) {
                    $price = $pricel->price;
                    $data['original_total'] = $price;
                    if ($service->discount && $service->discount > 0) {
                        $price = $pricel->price / 100 * (100 - (int)$service->discount);
                        $data['discount'] = $pricel->price / 100 * ((int)$service->discount);
                    }
                    $data['service_price'] = $price;
                    $data['total'] = $price;
                }
            }
        }
        $data['end_time'] = CarbonInterval::minutes($etime)->cascade()->format('%H:%I:00');
        $car = Car::find($data['car_id']);
        $pricelist = PriceList::where('service_id', $service->id)->where('size', $car->size)->first();
        if ($pricelist) {
            $total = $pricelist->price;
        } else {
            $total = 0;
        }
        if (!$this->checkAvT($request, $request->start_time)) {
            return Response()->json([
                'data'          => [
                ],
                'message'       => 'time not available',
                'code'          => getMsgCode('somethingWrong'),
            ]);
        }
        $order = $user->Order()->create($data);
        $order = new SingleOrderResource($order);
        $order->delete();
        
        return Response()->json([
            'data'          => [
                'order'  => $order
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }

    public function checkCoupon(Request $request)
    {
        $coupon = Coupon::where('coupon', $request->get('coupon'))
                            ->where('active', '1')
                            ->whereDate('start_date', '<=', Carbon::now())
                            ->whereDate('end_date', '>=', Carbon::now())
                            ->first();
        if($request->has('order_id') && Order::withTrashed()->find($request->get('order_id')))
        {
            $order = Order::withTrashed()->find($request->get('order_id'));
            if ($coupon->city_id && $coupon->city_id != $order->city_id) {
                $coupon = false;
            }

        }
            if (!$coupon) {
                return Response()->json([
                    'data'          => new \stdClass,
                    'message'       => 'notFound',
                    'code'          => getMsgCode('notFound'),
                ]);
            }
            $coupon = new CouponResource($coupon);
            return Response()->json([
                'data'          => [
                    'coupon'  => $coupon
                ],
                'message'       => 'success',
                'code'          => getMsgCode('success'),
            ]);
    }

    public function rate(Request $request)
    {
        $user = auth('api')->user();
        $order = $user->Order()->find($request->get('order_id'));
        $order->update(['rate' => $request->get('rate')]);
        
        $order = new SingleOrderResource($order);
        return Response()->json([
            'data'          => [
                'order'  => $order,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }

    public function checkAvT(Request $request , $tim)
    {
        $service_id = $request->get('service_id');
        $minutes = Service::find($service_id)->take_minutes;
        $day_date = $request->get('day_date');
        $city_id = '';
        if ($request->has('city_id') && $request->city_id) {
            $city_id = $request->get('city_id');
        }
        $s_t=getSettingValue('start_time');
        if (!Carbon::parse($day_date)->gt(Carbon::today())) {
            $s_t_h=Carbon::parse(getSettingValue('start_time'))->format('H');
            $s_t_i_s=Carbon::parse(getSettingValue('start_time'))->format('i:s');
            $n_t = Carbon::now()->format('H:i').':00';
            $n_t_h = Carbon::now()->format('H');
            if ($n_t_h > $s_t_h) {
                $s_t = $n_t_h . ':'.$s_t_i_s;
            }
        }
        $ap = new AppInfoController;
        $times = $ap->checkTimeT($s_t, getSettingValue('end_time'), $minutes,$day_date, $city_id, $service_id, $request);
        if (in_array($tim, $times)) {
            return true;
        }
        return false;
    }
   
    public function Payment(Request $request)
    {
        
        $user = auth('api')->user();
        $order = $user->Order()->find($request->order_id);
        if ($order) {
            if ($request->payment =='success') {
                $order->update(['status' => 'confirmed']);
            }else{
                $order->update(['status' => 'init']);

            }
        }
        return Response()->json([
            'data'          => new \stdClass,
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function waitingForPayment(Request $request)
    {
        
        $user = auth('api')->user();
        $order = $user->Order()->find($request->order_id);
        if ($order) {
                $order->update(['w_f_payment' => '1']);

        }
        return Response()->json([
            'data'          => new \stdClass,
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
}
