<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OrderItem extends Model
{
    protected $table='order_items';
    protected $fillable = [
        'order_id' , 'product_id' , 'service_id' , 'qty' , 'price' ,
    ];
    protected $appends = ['t_p'];

    public function Order()
    {
        return $this->belongsTo(Order::class, 'order_id');
    }

    public function Product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }
    public function Service()
    {
        return $this->belongsTo(Service::class, 'service_id');
    }

    public function getTPAttribute()
    {
        return $this->qty * $this->price;
    }

}
