@extends('admin.layout.app')
@section('style')
@endsection
@section('content')
@section('header')
<!-- Page title -->

<li>
    <div class="add-btn">
        <a href="{{ url('/dashboard/shifts/create') }}" type="button"
            class="btn btn-custom btn-rounded waves-effect waves-light w-md m-b-5"> <i class="fa fa-check"></i> اضافة
        </a>
    </div>
</li>

@endsection
<div class="row">
    
    <div class="col-sm-12">
        <div class="card-box table-responsive">
            <div class="row">

                <div class="col-md-12">
                    <div class="tab-content">

                        
                        <div role="tabpanel" class="tab-pane active" id="customers">
                            <table id="datatable-0" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th> الوقت من</th>
                                        <th>الوقت الي</th>
                                        <th>تعديل</th>
                                        <th>حذف</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach($shifts as $item)
                                    <tr>
                                        <td> {{$item->start_time}} </td>
                                        <td> {{$item->end_time}} </td>
                                        <td><a href="{{route('shifts.edit',$item)}}"><i class="fa fa-pencil  m-r-10" style="color: #188ae2;"></i> تعديل</a></td>
                                        <td> <a href="{{route('shifts.destroy',$item)}}" id="delete-btn" ><i class="fa fa-trash-o m-r-10" style="color: #5b69bc;"></i> حذف</a></td>
                                    </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>

                    </div>
                    
                </div>
            </div>
            
        </div>
    </div><!-- end col -->
</div>
<!-- end row -->
@endsection
@section('script')
@endsection