<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\Exportable;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;

class GeneralExport implements FromView, ShouldAutoSize, WithEvents
{
    use Exportable;
    public $items;
    public $blade;
    public function __construct( $items, $blade)
    {
        $this->items = $items;
        $this->blade = $blade;
    }
    public function registerEvents(): array
    {
        return [
            AfterSheet::class    => function(AfterSheet $event) {
                $event->sheet->getDelegate()->setRightToLeft(true);
                $event->sheet->styleCells(
                    'A1:N1',
                    [
                        'borders' => [
                            'outline' => [
                                'color' => ['argb' => 'FFFF0000'],
                            ],
                        ]
                    ]
                );
            },
        ];
    }

    public function view(): View
    {
        return view($this->blade, [
            'items' => $this->items
        ]);
    }
}
