<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Traits\Admin\BrandModelOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\BrandModel;
use Auth;
use Excel;
use App\Exports\GeneralExport;
use Carbon\Carbon;

class BrandModelController extends Controller
{
    use BrandModelOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    // public function __construct()
    // {
    //     $this->middleware('Permission:Brand_show'    , ['only' => 'index', 'show']);
    //     $this->middleware('Permission:Brand_add'     , ['only' => 'create', 'store']);
    //     $this->middleware('Permission:Brand_edit'    , ['only' => 'edit', 'update']);
    //     $this->middleware('Permission:Brand_delete'  , ['only' => 'destroy']);
    // }
    public function index()
    {
        $title = 'موديلات السيارات';
        $brand_models = BrandModel::latest();
            $brand_models = $brand_models->paginate(40);
        return view('admin.brand_models.index', compact('brand_models', 'title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة ';
        return view('admin.brand_models.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->register($request);
        return redirect('/dashboard/brand-models')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(BrandModel $brand_models)
    {
        $title = 'عرض ';
        return view('admin.brand_models.show', compact('brand_models', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $brand_models = BrandModel::find($id);
        $title = 'تعديل ';
        return view('admin.brand_models.edit', compact('brand_models', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
      
        $brand_models = BrandModel::find($id);
        $this->UpdateRecords($brand_models, $request);
      
        return redirect('dashboard/brand-models');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(BrandModel $brand_models)
    {
        if ($brand_models->form_image) {
            @unlink(public_path('/cdn/'.$brand_models->form_image));
        }
        $brand_models->delete();
        return 'success';
    }
}
