<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Traits\Admin\ColorOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Color;
use Auth;
use Excel;
use App\Exports\GeneralExport;
use Carbon\Carbon;

class ColorController extends Controller
{
    use ColorOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    // public function __construct()
    // {
    //     $this->middleware('Permission:color_show'    , ['only' => 'index', 'show']);
    //     $this->middleware('Permission:color_add'     , ['only' => 'create', 'store']);
    //     $this->middleware('Permission:color_edit'    , ['only' => 'edit', 'update']);
    //     $this->middleware('Permission:color_delete'  , ['only' => 'destroy']);
    // }
    public function index()
    {
        $title = 'الالوان';
        if (in_array( auth('admin')->user()->role, ['branch', 'employee']) || (auth('admin')->user()->role == 'employee' && auth()->user()->parent_id != '0' )) {
            // 
            if (auth('admin')->user()->role == 'branch') {
                $branch_id = auth('admin')->id();
            } else {
                $branch_id = auth('admin')->user()->parent_id;
            }
                $colors = Color::whereHas('BranchData', function($q) use( $branch_id ){
                    $q->where('admin_id', $branch_id);
                })->get();
            } else {
                $colors = Color::latest();
                
            }
            $search = array();
            if (Request()->has('id') && Request()->get('id') != '') {
                $id = Request()->get('id');
                $search['id'] = $id;
                $colors = $colors->where('id',$id);
            }
            if (Request()->has('name') && Request()->get('name') != '') {
                $name = Request()->get('name');
                $search['name'] = $name;
                $colors = $colors->where('structure_no'     , 'LIKE', '%'.$name.'%')->orWhere('name'     , 'LIKE', '%'.$name.'%');
            }
            if (Request()->has('excel') && Request()->get('excel') != '') {
                $colors = $colors->get();
                return Excel::download(new GeneralExport('admin.reports.colors-excel', $colors), 'colors-'.Colorbon::now()->toDateString().'.xlsx');
            }
            $colors = $colors->paginate(40);
        return view('admin.colors.index', compact('colors', 'title' , 'search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة ';
        return view('admin.colors.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->register($request);
        return redirect('/dashboard/colors')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Color $color)
    {
        $title = 'عرض ';
        return view('admin.colors.show', compact('color', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $color = Color::find($id);
        $title = 'تعديل ';
        return view('admin.colors.edit', compact('color', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
      
        $color = Color::find($id);
        $this->UpdateRecords($color, $request);
      
        return redirect('dashboard/colors');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Color $color)
    {
        if ($color->form_image) {
            @unlink(public_path('/cdn/'.$color->form_image));
        }
        $color->delete();
        return 'success';
    }
}
