<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateDriverRequest;
use App\Http\Requests\Admin\StoreDriverRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\DriverOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Driver;
use App\Models\Department;
use App\Models\City;
use Auth;
use Validator;
use Carbon\Carbon;
use App\Exports\GeneralExport;
use App\Models\Order;
use App\Models\OrderItem;
use App\Models\Product;
use App\Models\Service;
use Maatwebsite\Excel\Facades\Excel;

class DriverController extends Controller
{
    use DriverOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    
    public function __construct()
    {
        $this->middleware('Permission:drivers_show'    , ['only' => 'index', 'show']);
        $this->middleware('Permission:drivers_add'     , ['only' => 'create', 'store']);
        $this->middleware('Permission:drivers_edit'    , ['only' => 'edit', 'update']);
        $this->middleware('Permission:drivers_delete'  , ['only' => 'destroy']);
    }

    public function index() //get
    {
       
            $drivers = Driver::latest();


        $search = array();
        if (Request()->has('name') && Request()->get('name') != '') {
            $name = Request()->get('name');
            $search['name'] = $name;
            $drivers = $drivers->where('name'     , 'LIKE', '%'.$name.'%');
        }
        if (Request()->has('phone') && Request()->get('phone') != '') {
            $phone = Request()->get('phone');
            $search['phone'] = $phone;
            $drivers = $drivers->where('phone'     , 'LIKE', '%'.$phone.'%');
        }
       
        $drivers = $drivers->paginate(30);
        
        $title = 'السائقين';
        return view('admin.drivers.index', compact('drivers', 'title', 'search'));


    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة سائق';
        $zones = [];
        return view('admin.drivers.add', compact('title', 'zones'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreDriverRequest $request)
    {
        // return $request->all();
        $this->register($request);
        return redirect('/dashboard/drivers')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request, Driver $driver)
    {
        $title = 'عرض سائق';
        $orders = $driver->Order()->latest();
        $vacations = $driver->Vacation()->latest()->paginate(40)->setPageName('other_page');
        $finances = $driver->Finance()->latest()->paginate(20)->setPageName('o_page');
        $last_finance = $driver->Finance()->latest()->first();
        
        $search = array();
        if (Request()->has('serial') && Request()->get('serial') != '') {
            $serial = Request()->get('serial');
            $search['serial'] = $serial;
            $orders = $orders->where('serial'  ,$serial);
        }
        if (Request()->has('user_id') && Request()->get('user_id') != '') {
            $user_id = Request()->get('user_id');
            $search['user_id'] = $user_id;
            $orders = $orders->where('user_id'  ,$user_id);
        }
        if (Request()->has('driver_id') && Request()->get('driver_id') != '') {
            $driver_id = Request()->get('driver_id');
            $search['driver_id'] = $driver_id;
            $orders = $orders->where('driver_id'  ,$driver_id);
        }
        if ($request->has('date_from') && $request->get('date_from') != '') {
            $date_from = Carbon::parse($request->get('date_from') );
            $search['date_from'] = $request->get('date_from');
            $orders = $orders->whereDate('day_date', '>=', $date_from);
            if (!$request->has('date_to') || $request->get('date_to') == '') {
                $orders = $orders->whereDate('day_date', '=', $date_from);
            }
        }
        if ($request->has('date_to') && $request->get('date_to') != '') {
            $date_to = Carbon::parse($request->get('date_to') );
            $search['date_to'] = $request->get('date_to');
            $orders = $orders->whereDate('day_date', '<=', $date_to);
        }
        if (Request()->has('id') && Request()->get('id') != '') {
            $id = Request()->get('id');
            $search['id'] = $id;
            $orders = $orders->where('id'     ,$id);
        }
        
        if (Request()->has('user') && Request()->get('user') != '') {
            $user = Request()->get('user');
            $search['user'] = $user;
            $orders = $orders->wherehas('User', function($q) use ($user){
                $q->where('name'     , 'LIKE', '%'.$user.'%')
                ->Orwhere('phone'     , 'LIKE', '%'.$user.'%');
            });
        }
        if (Request()->has('service') && Request()->get('service') != '') {
            $service = Request()->get('service');
            $search['service'] = $service;
            $orders = $orders->where('service_id'     ,$service);
        }
        if (Request()->has('driver') && Request()->get('driver') != '') {
            $driver = Request()->get('driver');
            $search['driver'] = $driver;
            $orders = $orders->where('driver_id'     ,$driver);
        }
        if (Request()->has('status') && Request()->get('status') != '') {
            $status = Request()->get('status');
            $search['status'] = $status;
            $orders = $orders->where('status'     ,$status);
        }
        $orders = $orders->paginate(40);
        $services_chart = $driver->Order()->select( \DB::raw('COUNT(*) as a, service_id as y'))
                            // ->groupBy('user_id')
                            ->groupBy('y')
                            ->get()->each(function($i){
                                $i->y = Service::find($i->y)->name;
                            })->makeHidden(['start', 'end', 'car_size', 'updated_at_stamp', 'car']);
        $prods_chart = OrderItem::whereHas('Order', function($q)use($driver){$q->where('driver_id', $driver->id);})
                            ->select( \DB::raw('COUNT(*) as a, product_id as y'))
                            // ->groupBy('user_id')
                            ->groupBy('y')
                            ->get()->each(function($i){
                                $i->y = Product::find($i->y)->name;
                            })->makeHidden(['start', 'end', 'car_size', 'updated_at_stamp', 'car']);
        return view('admin.drivers.show', compact('driver', 'title', 'orders', 'search', 'vacations', 'finances', 'last_finance', 'services_chart', 'prods_chart'));
    }
    public function DriverInfo($id)
    {
        $driver = Driver::find($id);
        $title = 'عرض سائق';
        return view('admin.drivers.ajax_data', compact('driver', 'title'))->render();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $driver = Driver::find($id);
        $title = 'تعديل سائق';
        $zones = [];
        if ($driver->city_id) {
            $zones = City::where('parent', $driver->city_id)->pluck('name_ar', 'id')->toArray();
        }
        return view('admin.drivers.edit', compact('driver', 'title', 'zones'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateDriverRequest $request, Driver $driver)
    {
        // $driver = Driver::find($id);
        $this->UpdateRecords($driver, $request);
        return redirect('/dashboard/drivers')->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Driver $driver)
    {
        if ($driver->image) {
            @unlink(public_path('/cdn/'.$driver->image));
        }
        $driver->delete();
        return 'success';
    }
    public function finance(Request $request, $driver)
    {
        $driver = Driver::find($driver);
        // return $driver;
        $rows = $driver->Finance()->create([
            'driver_amount' => $request->get('driver_amount'),
            'company_amount' => $request->get('company_amount'),
            'notes' => $request->get('notes'),
            'admin_id' => auth('admin')->id(),
            'type' => 'creditor',
        ]);
        // $rows;
        return back()->with('success', 'تم التصفية');
    }
}
