<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Traits\Admin\SubscribeOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Subscribe;
use Auth;
use Excel;
use App\Exports\GeneralExport;
use App\Models\Coupon;
use App\Models\PriceList;
use App\Models\Product;
use App\Models\SubscribeItem;
use App\Models\User;
use Carbon\Carbon;

class SubscribeController extends Controller
{
    use SubscribeOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    public function __construct()
    {
        $this->middleware('Permission:subscribes_show'    , ['only' => 'index', 'show']);
        $this->middleware('Permission:subscribes_add'     , ['only' => 'create', 'store']);
        $this->middleware('Permission:subscribes_edit'    , ['only' => 'edit', 'update']);
        $this->middleware('Permission:subscribes_delete'  , ['only' => 'destroy']);
    }
    public function index()
    {
        $title = 'الاشتراكات';

            $subscribes = Subscribe::latest();
            $search = array();
            if (Request()->has('id') && Request()->get('id') != '') {
                $id = Request()->get('id');
                $search['id'] = $id;
                $subscribes = $subscribes->where('id',$id);
            }
            if (Request()->has('name') && Request()->get('name') != '') {
                $name = Request()->get('name');
                $search['name'] = $name;
                $subscribes = $subscribes->where('structure_no'     , 'LIKE', '%'.$name.'%')->orWhere('name'     , 'LIKE', '%'.$name.'%');
            }
            if (Request()->has('excel') && Request()->get('excel') != '') {
                $subscribes = $subscribes->get();
                return Excel::download(new GeneralExport($subscribes,'admin.reports.subscribes-excel'), 'subscribes-'.Carbon::now()->toDateString().'.xlsx');
            }
            $subscribes = $subscribes->paginate(40);
        return view('admin.subscribes.index', compact('subscribes', 'title' , 'search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة ';
        $subscribe = null;
        return view('admin.subscribes.add', compact('title', 'subscribe'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $row =$this->register($request);
        $this->recalculateOrder($row->id);
        return redirect(route('subscribes.edit', $row))->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Subscribe $subscribe)
    {
        $title = 'عرض ';
        if (request()->has('print')) {
            return view('admin.subscribes.bill', compact('subscribe', 'title'));

        }
        return view('admin.subscribes.show', compact('subscribe', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $subscribe = Subscribe::find($id);
        $title = 'تعديل ';
        return view('admin.subscribes.edit', compact('subscribe', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $subscribe = Subscribe::find($id);
        $this->UpdateRecords($subscribe, $request);
        $this->recalculateOrder($subscribe->id);

        return redirect('dashboard/subscribes');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Subscribe $subscribe)
    {
        if ($subscribe->form_image) {
            @unlink(public_path('/cdn/'.$subscribe->form_image));
        }
        $subscribe->delete();
        return 'success';
    }

    // *******************************************
        // items
        public function Itemcreate()
        {
            $title = 'اضافة منتج';
            return view('admin.subscribes.add-item', compact('title'));
        }

        /**
         * Store a newly created resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @return \Illuminate\Http\Response
         */
        public function Itemstore(Request $request)
        {
            $subscribe = Subscribe::findOrfail($request->subscribe_id);
            $data = $request->all();
            if ($subscribe->SubscribeItem()->where('product_id',$request->product_id)->count() > 0) {
                return redirect()->back()->with('warning', 'هذا المنتج موجود بالفعل');

            }
            $pro = Product::find($request->product_id);
                    // if ($pro->discount && $pro->discount > 0) {
                    //     $price = $pro->price / 100 * (100- (int)$pro->discount);
                    // } else {
                        $price = $pro->price;
                    // }
                    $data['price'] = $price;
            $subscribe->SubscribeItem()->create($data);
            $this->recalculateOrder($subscribe->id);
            return redirect()->back()->with('success', 'data added successfully');
        }
        public function clientcreate()
        {
            $title = 'اضافة عميل';
            return view('admin.subscribes.add-client', compact('title'));
        }

        /**
         * Store a newly created resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @return \Illuminate\Http\Response
         */
        public function clienttore(Request $request)
        {
            $data = $request->all();
            $user = User::create($data);
            return \Form::select("user_id",Users(), $user->id,['class'=>'form-control',
            'required'=>'']);
        }



        /**
         * Show the form for editing the specified resource.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function Itemedit($id)
        {
            $item = SubscribeItem::find($id);
            $title = 'تعديل المنتج';
            return view('admin.subscribes.edit-item', compact('item', 'title'));
        }

        /**
         * Update the specified resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function Itemupdate(Request $request, $id)
        {

            $item = SubscribeItem::find($id);
            $data = $request->all();
            $pro = Product::find($request->product_id);
                    if ($pro->discount && $pro->discount > 0) {
                        $price = $pro->price / 100 * (100- (int)$pro->discount);
                    } else {
                        $price = $pro->price;
                    }
                    $data['price'] = $price;
            $item->update($data);
            $this->recalculateOrder($item->subscribe_id);
            return redirect()->back()->with('success', 'data updated successfully');
        }

        /**
         * Remove the specified resource from storage.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function Itemdestroy($id)
        {
            $subscribe_id = SubscribeItem::find($id)->subscribe_id;
            SubscribeItem::find($id)->delete();
            return 'success';
        }
        public function recalculateOrder($id)
        {
            $total = 0;
            $discount = 0;
            $row = Subscribe::find($id);
            $cleans = $row->SubscribeItem()->whereNotNull('size')->get();
            foreach ($cleans as $cl) {
                $pricelist = PriceList::where('service_id', $cl->service_id)->where('size', $cl->size)->first();
                if ($pricelist) {
                    $total += ($pricelist->price * $cl->qty);
                }
            }//cleans cal end
            if ($row->coupon) {
                $coupon = Coupon::where('coupon', $row->coupon)
                                ->first();

                if ($coupon) {

                        $percent = $coupon->amount;
                        $discount = $total / 100 * $percent;
                        $total = $total - $discount;
                        $row->update(['coupon_amount' => $discount ]);

                }
            }

            $price = 0;
            $price_m = 0;
            $pricem = 0;
            $o_price = 0;
            foreach ($row->SubscribeItem()->whereNotNull('product_id')->get() as $item) {
                $pro = $item->Product()->first();
                if ($pro->discount && $pro->discount > 0) {
                    $price = $pro->price / 100 * (100- (int)$pro->discount);
                    $dis_price = $pro->price / 100 * ((int)$pro->discount);
                    $discount = $discount + ($dis_price * $item['qty']);
                } else {
                    $price = $pro->price;
                }
                // $pricem .= ' / ' . $price;
                    $price_m += ($price * $item->qty);
                    $o_price += ($pro->price * $item->qty);
            }//products cal end

            $row->update(['total_price' => $total + $price_m, 'original_total' => $total + $o_price, 'discount' =>  $discount]);
            $tax = (float)getSettingValue('tax');
            $total = $row->total_price + (($row->total_price / 100) * $tax);
            $row->update(['tax' => $tax, 'total_price' => $total ]);
            // was coupon here

        }
}
