<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Traits\Api\AddressOperations;
use App\Http\Requests\Api\StoreAddressRequest;
use App\Http\Resources\Api\AddressResource;
use Auth;
use App\Models\User;
use App\Models\Address;

class AddressController extends Controller
{
    use AddressOperations;

    public function store(StoreAddressRequest $request)
    {
    	$user = Auth::guard('api')->user();
        $address = $this->register($request);
        $addresses = $user->Address()->get();
        $addresses = AddressResource::collection($addresses);
    	return Response()->json([
                'data' => [
                    'addresses' => $addresses,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }

    public function AllAddresses(Request $request)
    {
        $user = Auth::guard('api')->user();
        $addresses = $user->Address()->get();
        $addresses = AddressResource::collection($addresses);
        return Response()->json([
                'data' => [
                    'addresses' => $addresses,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }

    public function GetAddress($id)
    {
        $user = Auth::guard('api')->user();
        $address = $user->Address()->find($id);
        $address = new AddressResource($address);
        return Response()->json([
                'data' => [
                    'address' => $address,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }


    public function UpdateAddress(Request $request, $id)
    {
        $user = Auth::guard('api')->user();
        $address = $user->Address()->find($id);
        $this->UpdateRecords($address, $request);
        $addresses = $user->Address()->get();
        $addresses = AddressResource::collection($addresses);
        return Response()->json([
                'data' => [
                    'addresses' => $addresses,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }


    public function DeleteAddress(Request $request, $id)
    {
        $user = Auth::guard('api')->user();
        $address = $user->Address()->find($id);
        if ($address) {
            $address->delete();
        }
        $addresses = $user->Address()->get();
        $addresses = AddressResource::collection($addresses);
        return Response()->json([
                'data' => [
                    'addresses' => $addresses,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
}
