<?php

namespace App\Http\Middleware;

use Closure;
use Auth;

class PermissionsMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next, $role)
    {
        if (Auth::guard('admin')->user()->role != 'admin' && (!Auth::guard('admin')->user()->UserRole()->first() || Auth::guard('admin')->user()->UserRole->Role->Permission()->where('permission', $role)->count() == 0 ) ) {
            if($request->ajax())
            {
                // return 'عفوا ليس لديك صلاحية هذا الاجراء';
                return Response()->json(['عفوا ليس لديك صلاحية هذا الاجراء']);
            }
            return redirect()->back()->with('error', 'not have a permission');
        }
        return $next($request);
    }
}
